/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatables;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import io.jenkins.plugins.util.JenkinsFacade;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import org.apache.commons.lang3.StringUtils;
import org.jenkins.ui.symbol.SymbolRequest;

public class TableColumn {
    private final String headerLabel;
    private final String definition;
    private ColumnCss headerClass = ColumnCss.NONE;
    private int width = 1;

    public static String renderDetailsColumn(String detailsText) {
        return TableColumn.renderDetailsColumn(detailsText, new JenkinsFacade());
    }

    public static String renderDetailsColumn(String detailsText, JenkinsFacade jenkinsFacade) {
        return ((ContainerTag)((ContainerTag)TagCreator.div().withClass("details-control")).attr("data-description", (Object)detailsText)).with((DomContent)TagCreator.join((Object[])new Object[]{TableColumn.symbol("add", "open", jenkinsFacade), TableColumn.symbol("remove", "close", jenkinsFacade)})).render();
    }

    private static String symbol(String imageName, String cssId, JenkinsFacade jenkins) {
        return jenkins.getSymbol(new SymbolRequest.Builder().withName(imageName + "-circle-outline").withPluginName("ionicons-api").withClasses("details-icon details-icon-" + cssId).build());
    }

    private TableColumn(String definition, String headerLabel, ColumnCss headerClass) {
        this.headerLabel = headerLabel;
        this.definition = definition;
        this.headerClass = headerClass;
    }

    @Deprecated
    public TableColumn(String headerLabel, String dataPropertyName) {
        this.headerLabel = headerLabel;
        this.definition = String.format("{  \"data\": \"%s\",  \"defaultContent\": \"\"}", dataPropertyName);
    }

    @Deprecated
    public TableColumn(String headerLabel, String dataPropertyName, String columnDataType) {
        this.headerLabel = headerLabel;
        this.definition = String.format("{  \"type\": \"%s\",  \"data\": \"%s\",  \"defaultContent\": \"\",  \"render\": {     \"_\": \"display\",     \"sort\": \"sort\"  }}", columnDataType, dataPropertyName);
    }

    @Deprecated
    public TableColumn setHeaderClass(ColumnCss headerClass) {
        this.headerClass = headerClass;
        return this;
    }

    @Deprecated
    public TableColumn setWidth(int width) {
        this.width = width;
        return this;
    }

    public String getHeaderLabel() {
        return this.headerLabel;
    }

    public String getHeaderClass() {
        return this.headerClass.toString();
    }

    @Deprecated
    public int getWidth() {
        return this.width;
    }

    public String getDefinition() {
        return this.definition;
    }

    public static enum ColumnCss {
        NONE(""),
        DATE("date"),
        PERCENTAGE("percentage"),
        NUMBER("text-end"),
        NO_SORT("nosort"),
        HIDDEN("hidden");

        private final String cssClass;

        private ColumnCss(String cssClass) {
            this.cssClass = cssClass;
        }

        public String toString() {
            return this.cssClass;
        }
    }

    public static enum ColumnType {
        DATE("date"),
        NUMBER("num"),
        HTML_NUMBER("html-num"),
        FORMATTED_NUMBER("num-fmt"),
        FORMATTED_HTML_NUMBER("html-num-fmt"),
        STRING("string");

        private final String dataTablesType;

        private ColumnType(String dataTablesType) {
            this.dataTablesType = dataTablesType;
        }

        public String toString() {
            return this.dataTablesType;
        }
    }

    public static class ColumnBuilder {
        private static final int DEFAULT_PRIORITY = 10000;
        @CheckForNull
        private String header;
        @CheckForNull
        private String propertyKey;
        private ColumnType type = ColumnType.STRING;
        private int responsivePriority = 10000;
        private ColumnCss headerCssClass = ColumnCss.NONE;
        private boolean isDetailedCellEnabled = false;

        public ColumnBuilder withType(ColumnType columnType) {
            this.type = columnType;
            switch (columnType) {
                case NUMBER: 
                case HTML_NUMBER: 
                case FORMATTED_NUMBER: 
                case FORMATTED_HTML_NUMBER: {
                    this.withHeaderClass(ColumnCss.NUMBER);
                    break;
                }
            }
            return this;
        }

        public ColumnBuilder withDataPropertyKey(String dataPropertyKey) {
            this.propertyKey = dataPropertyKey;
            return this;
        }

        public ColumnBuilder withResponsivePriority(int priority) {
            if (priority < 0) {
                throw new IllegalArgumentException("Responsive priority " + priority + " must be a positive value");
            }
            this.responsivePriority = priority;
            return this;
        }

        public ColumnBuilder withHeaderLabel(String headerLabel) {
            this.header = headerLabel;
            return this;
        }

        public ColumnBuilder withHeaderClass(ColumnCss headerClass) {
            this.headerCssClass = headerClass;
            return this;
        }

        public ColumnBuilder withDetailedCell() {
            this.isDetailedCellEnabled = true;
            return this;
        }

        public TableColumn build() {
            if (StringUtils.isBlank((CharSequence)this.header)) {
                throw new IllegalArgumentException("Empty header label, see #withHeaderLabel");
            }
            return new TableColumn(this.createDefinition(), this.header, this.headerCssClass);
        }

        private String createDefinition() {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode columnDefinition = mapper.createObjectNode();
            try {
                if (this.propertyKey == null) {
                    throw new IllegalArgumentException("No 'dataPropertyKey' defined, see #withDataPropertyKey");
                }
                columnDefinition.put("data", this.propertyKey);
                columnDefinition.put("type", this.type.dataTablesType);
                if (this.responsivePriority != 10000) {
                    columnDefinition.put("responsivePriority", this.responsivePriority);
                }
                if (this.isDetailedCellEnabled) {
                    ObjectNode detailedRenderer = mapper.createObjectNode();
                    detailedRenderer.put("_", "display");
                    detailedRenderer.put("sort", "sort");
                    columnDefinition.set("render", (JsonNode)detailedRenderer);
                }
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)columnDefinition);
            }
            catch (JsonProcessingException exception) {
                throw new IllegalArgumentException("Can't convert to JSON: " + String.valueOf(columnDefinition), exception);
            }
        }
    }
}

