/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatables;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import io.jenkins.plugins.util.PageObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class TableRowPageObject
extends PageObject {
    private final Map<String, String> valueByColumn = new HashMap<String, String>();
    private final Map<String, HtmlTableCell> cellsByColumn = new HashMap<String, HtmlTableCell>();

    TableRowPageObject(HtmlPage page, List<String> columnLabels, List<HtmlTableCell> values) {
        super(page);
        ((AbstractIntegerAssert)Assertions.assertThat((int)columnLabels.size()).as("Size of column headers and values must match", new Object[0])).isEqualTo(values.size());
        for (int pos = 0; pos < columnLabels.size(); ++pos) {
            String key = columnLabels.get(pos);
            HtmlTableCell cell = values.get(pos);
            this.cellsByColumn.put(key, cell);
            this.valueByColumn.put(key, this.getCellContent(cell));
        }
    }

    private String getCellContent(HtmlTableCell cell) {
        String dataDescription;
        DomElement child = cell.getFirstElementChild();
        if (child != null && StringUtils.isNotBlank((CharSequence)(dataDescription = this.getDescriptionContent(child)))) {
            return dataDescription;
        }
        return cell.getTextContent();
    }

    private String getDescriptionContent(DomElement child) {
        String dataDescription = child.getAttributeDirect("data-description");
        if (StringUtils.isNotBlank((CharSequence)dataDescription)) {
            return dataDescription.replace("<p><strong>", "").replace("</strong></p>", "");
        }
        return "";
    }

    public boolean hasLink(String column) {
        return this.getLink(column) instanceof HtmlAnchor;
    }

    public DomElement getLink(String column) {
        return this.cellsByColumn.get(column).getFirstElementChild();
    }

    public HtmlPage clickColumnLink(String column) {
        Assertions.assertThat((boolean)this.hasLink(column)).isTrue();
        DomElement link = this.getLink(column);
        return TableRowPageObject.clickOnElement((DomElement)link);
    }

    public Map<String, String> getValuesByColumnLabel() {
        return this.valueByColumn;
    }
}

