/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.datatables;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableBody;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.datatables.TableRowPageObject;
import io.jenkins.plugins.util.PageObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;

public class TablePageObject
extends PageObject {
    private final List<TableRowPageObject> rows = new ArrayList<TableRowPageObject>();
    private final List<String> columnHeaders;
    private final DomElement summary;
    private final DomElement filter;
    private final HtmlTableBody body;

    @SuppressFBWarnings(value={"BC"})
    public TablePageObject(HtmlPage page, String tableId) {
        super(page);
        DomElement tableDom = page.getElementById(tableId);
        Assertions.assertThat((Object)tableDom).isInstanceOf(HtmlTable.class);
        HtmlTable table = (HtmlTable)tableDom;
        List headerRows = table.getHeader().getRows();
        Assertions.assertThat((List)headerRows).hasSize(1);
        HtmlTableRow header = (HtmlTableRow)headerRows.get(0);
        this.columnHeaders = this.getHeaders(header.getCells());
        this.waitUntilTableIsInitialized(table);
        List bodies = table.getBodies();
        Assertions.assertThat((List)bodies).hasSize(1);
        this.body = (HtmlTableBody)bodies.get(0);
        this.waitForAjaxCall(this.body);
        this.updateVisibleRows();
        this.summary = page.getElementById(tableId + "_info");
        this.filter = page.getElementById(tableId + "_filter");
    }

    private void updateVisibleRows() {
        this.rows.clear();
        for (HtmlTableRow row : this.body.getRows()) {
            this.rows.add(new TableRowPageObject(this.getPage(), this.columnHeaders, row.getCells()));
        }
    }

    private void waitUntilTableIsInitialized(HtmlTable table) {
        while (table.getBodies().isEmpty()) {
            System.out.println("Waiting for table to be initialized ...");
            table.getPage().getEnclosingWindow().getJobManager().waitForJobs(1000L);
        }
    }

    private void waitForAjaxCall(HtmlTableBody body) {
        while ("Loading - please wait ...".equals(((HtmlTableCell)((HtmlTableRow)body.getRows().get(0)).getCells().get(0)).getFirstChild().getTextContent())) {
            System.out.println("Waiting for Ajax call to populate issues table ...");
            body.getPage().getEnclosingWindow().getJobManager().waitForJobs(1000L);
        }
    }

    public List<TableRowPageObject> getRows() {
        return this.rows;
    }

    public List<String> getColumnHeaders() {
        return this.columnHeaders;
    }

    private List<String> getHeaders(List<HtmlTableCell> cells) {
        return cells.stream().map(DomNode::getTextContent).collect(Collectors.toList());
    }

    public TableRowPageObject getRow(int index) {
        return this.rows.get(index);
    }

    public String getInfo() {
        return this.summary.getTextContent();
    }

    public int size() {
        return this.rows.size();
    }

    public void filter(String filterText) {
        try {
            HtmlTextInput searchControl = (HtmlTextInput)this.filter.getElementsByTagName("input").get(0);
            searchControl.type(filterText);
            this.updateVisibleRows();
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

