/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import hudson.util.FormValidation;
import io.jenkins.plugins.customizable_header.AbstractLink;
import io.jenkins.plugins.customizable_header.ContextAwareLogo;
import io.jenkins.plugins.customizable_header.HeaderRootAction;
import io.jenkins.plugins.customizable_header.SystemMessage;
import io.jenkins.plugins.customizable_header.UserHeader;
import io.jenkins.plugins.customizable_header.color.HeaderColor;
import io.jenkins.plugins.customizable_header.headers.ContextSelector;
import io.jenkins.plugins.customizable_header.headers.HeaderDescriptor;
import io.jenkins.plugins.customizable_header.headers.HeaderSelector;
import io.jenkins.plugins.customizable_header.headers.JenkinsHeaderSelector;
import io.jenkins.plugins.customizable_header.headers.JenkinsWrapperHeaderSelector;
import io.jenkins.plugins.customizable_header.headers.LogoSelector;
import io.jenkins.plugins.customizable_header.headers.SectionedHeaderSelector;
import io.jenkins.plugins.customizable_header.links.FolderLinks;
import io.jenkins.plugins.customizable_header.links.JobLinks;
import io.jenkins.plugins.customizable_header.logo.DefaultLogo;
import io.jenkins.plugins.customizable_header.logo.Icon;
import io.jenkins.plugins.customizable_header.logo.Logo;
import io.jenkins.plugins.customizable_header.logo.LogoDescriptor;
import io.jenkins.plugins.customizable_header.logo.Symbol;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.appearance.AppearanceCategory;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

@Extension
@org.jenkinsci.Symbol(value={"customHeader"})
public class CustomHeaderConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(CustomHeaderConfiguration.class.getName());
    private String title = "";
    private String cssResource;
    private String logoText = "Jenkins";
    private Logo logo = new Symbol("symbol-jenkins");
    private HeaderSelector header = new JenkinsWrapperHeaderSelector();
    private boolean enabled = false;
    private transient String cssResourceUrl;
    private HeaderColor headerColor = new HeaderColor("black", "white");
    private boolean thinHeader;
    private transient SystemMessage systemMessage;
    private final List<SystemMessage> systemMessages = new ArrayList<SystemMessage>();
    private List<AbstractLink> links = new ArrayList<AbstractLink>();
    private ContextAwareLogo contextAwareLogo;

    @DataBoundConstructor
    public CustomHeaderConfiguration() {
        this.load();
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(AppearanceCategory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        boolean result = false;
        try (BulkChange bc = new BulkChange((Saveable)this);){
            this.links.clear();
            this.contextAwareLogo = null;
            List<SystemMessage> list = this.systemMessages;
            synchronized (list) {
                this.systemMessages.clear();
                result = super.configure(req, json);
            }
            this.headerColor.setUserColors(false);
            bc.commit();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + String.valueOf(this.getConfigFile()), e);
        }
        return result;
    }

    private void convertOldHeaders() {
        HeaderSelector headerSelector = this.header;
        if (headerSelector instanceof ContextSelector) {
            ContextSelector cs = (ContextSelector)headerSelector;
            this.contextAwareLogo = new ContextAwareLogo();
            this.contextAwareLogo.setShowFolderWeather(cs.isShowFolderWeather());
            this.contextAwareLogo.setShowJobWeather(cs.isShowJobWeather());
            this.contextAwareLogo.setSymbolMappingFile(cs.getSymbolMappingFile());
            this.header = new SectionedHeaderSelector();
        }
        if (this.header instanceof LogoSelector) {
            this.header = new SectionedHeaderSelector();
        }
        if (this.header instanceof JenkinsHeaderSelector) {
            this.header = new JenkinsWrapperHeaderSelector();
            this.enabled = false;
        }
    }

    public Object readResolve() {
        if (this.systemMessage != null) {
            this.systemMessages.add(this.systemMessage);
        }
        this.convertOldHeaders();
        this.headerColor.setUserColors(false);
        return this;
    }

    @Deprecated
    public SystemMessage getSystemMessage() {
        return this.systemMessage;
    }

    @Deprecated
    @DataBoundSetter
    public void setSystemMessage(SystemMessage systemMessage) {
        this.systemMessage = systemMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SystemMessage> getSystemMessages() {
        List<SystemMessage> list = this.systemMessages;
        synchronized (list) {
            UserHeader userHeader;
            Set currentUids = this.systemMessages.stream().map(SystemMessage::getUid).collect(Collectors.toSet());
            User user = User.current();
            if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null && userHeader.getDismissedMessages().removeIf(dismissedUid -> !currentUids.contains(dismissedUid))) {
                try {
                    user.save();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to save user properties", e);
                }
            }
            if (this.systemMessages.removeIf(sm -> sm.isExpired() || sm.getMessage() == null)) {
                this.save();
            }
        }
        return Collections.unmodifiableList(this.systemMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DataBoundSetter
    public void setSystemMessages(List<SystemMessage> systemMessages) {
        List<SystemMessage> list = this.systemMessages;
        synchronized (list) {
            this.systemMessages.clear();
            this.systemMessages.addAll(systemMessages);
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemMessage(SystemMessage message) {
        List<SystemMessage> list = this.systemMessages;
        synchronized (list) {
            this.systemMessages.add(message);
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSystemMessage(String id) {
        List<SystemMessage> list = this.systemMessages;
        synchronized (list) {
            this.systemMessages.removeIf(sm -> sm.getUid().equals(id));
        }
        this.save();
    }

    public List<AbstractLink> getLinks() {
        return this.links;
    }

    @DataBoundSetter
    public void setLinks(List<AbstractLink> links) {
        this.links = links;
        this.save();
    }

    private boolean hasFavorites() {
        User user;
        if (Jenkins.get().getPlugin("favorite") != null && (user = User.current()) != null) {
            Iterable items = Favorites.getFavorites((User)user);
            return items.iterator().hasNext();
        }
        return false;
    }

    private boolean hasAppLinks() {
        if (this.links == null) {
            return false;
        }
        return !this.links.isEmpty();
    }

    private boolean hasUserLinks() {
        UserHeader userHeader;
        User user = User.current();
        if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null) {
            return userHeader.getLinks() != null && !userHeader.getLinks().isEmpty();
        }
        return false;
    }

    public boolean hasContextLinks() {
        ArrayList ancestors = new ArrayList(Stapler.getCurrentRequest2().getAncestors());
        for (Ancestor ancestor : ancestors) {
            Job job;
            JobLinks jobLinks;
            Object obj = ancestor.getObject();
            if (obj instanceof Job && (jobLinks = (JobLinks)(job = (Job)obj).getProperty(JobLinks.class)) != null) {
                return true;
            }
            if (!(obj instanceof AbstractFolder)) continue;
            AbstractFolder folder = (AbstractFolder)obj;
            for (AbstractFolderProperty prop : folder.getProperties()) {
                FolderLinks folderLinks;
                if (!(prop instanceof FolderLinks) || (folderLinks = (FolderLinks)prop).getLinks().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLinks() {
        return Jenkins.get().hasPermission(Jenkins.READ) && (this.hasFavorites() || this.hasAppLinks() || this.hasUserLinks() || this.hasContextLinks());
    }

    public boolean isThinHeader() {
        UserHeader userHeader;
        User user = User.current();
        if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null && userHeader.isEnabled()) {
            return userHeader.isThinHeader();
        }
        return this.thinHeader;
    }

    @DataBoundSetter
    public void setContextAwareLogo(ContextAwareLogo contextAwareLogo) {
        this.contextAwareLogo = contextAwareLogo;
    }

    public ContextAwareLogo getContextAwareLogo() {
        return this.contextAwareLogo;
    }

    @DataBoundSetter
    public void setThinHeader(boolean thinHeader) {
        this.thinHeader = thinHeader;
        this.save();
    }

    @DataBoundSetter
    public void setHeader(HeaderSelector header) {
        this.header = header;
        this.convertOldHeaders();
        this.save();
    }

    public HeaderSelector getHeader() {
        return this.header;
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.save();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @DataBoundSetter
    public void setLogo(Logo logo) {
        this.logo = logo;
        this.save();
    }

    public Logo getLogo() {
        return this.logo;
    }

    public Logo getActiveLogo() {
        UserHeader userHeader;
        if (!this.isEnabled()) {
            return new DefaultLogo();
        }
        Logo logo = null;
        User user = User.current();
        ContextAwareLogo cal = this.contextAwareLogo;
        if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null && userHeader.isEnabled() && userHeader.getContextAwareLogo() != null) {
            cal = userHeader.getContextAwareLogo();
        }
        if (cal != null) {
            logo = cal.getLogo();
        }
        if (logo == null) {
            logo = this.logo;
        }
        return logo;
    }

    @DataBoundSetter
    public void setHeaderColor(HeaderColor headerColor) {
        this.headerColor = headerColor;
        this.save();
    }

    public HeaderColor getHeaderColor() {
        return this.headerColor;
    }

    public HeaderColor getActiveHeaderColor() {
        UserHeader userHeader;
        User user = User.current();
        if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null && userHeader.isEnabled()) {
            return userHeader.getHeaderColor();
        }
        return this.headerColor;
    }

    public HeaderSelector getActiveHeader() {
        if (this.enabled) {
            return this.header;
        }
        return null;
    }

    @DataBoundSetter
    public void setLogoText(String logoText) {
        this.logoText = logoText;
        this.save();
    }

    public String getLogoText() {
        return this.logoText;
    }

    public static CustomHeaderConfiguration get() {
        return (CustomHeaderConfiguration)((Object)GlobalConfiguration.all().get(CustomHeaderConfiguration.class));
    }

    public String getTitle() {
        return this.title;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
        this.save();
    }

    public String getCssResource() {
        return Util.fixEmptyAndTrim((String)this.cssResource);
    }

    @DataBoundSetter
    public void setCssResource(String cssResource) {
        this.cssResource = cssResource;
        this.setCssResourceUrl();
        this.save();
    }

    private void setCssResourceUrl() {
        this.cssResourceUrl = Util.fixEmptyAndTrim((String)this.cssResource) != null ? this.cssResource : "";
    }

    @NonNull
    public String getCssResourceUrl() {
        if (this.cssResourceUrl == null) {
            this.setCssResourceUrl();
        }
        return this.cssResourceUrl;
    }

    public List<Descriptor<Logo>> getLogoDescriptors() {
        return LogoDescriptor.all().stream().filter(d -> !(d instanceof Icon.DescriptorImpl)).collect(Collectors.toList());
    }

    public List<Descriptor<HeaderSelector>> getHeaderDescriptors() {
        return HeaderDescriptor.all().stream().filter(d -> !(d instanceof ContextSelector.DescriptorImpl) && !(d instanceof LogoSelector.DescriptorImpl) && !(d instanceof JenkinsHeaderSelector.DescriptorImpl)).collect(Collectors.toList());
    }

    @POST
    public FormValidation doCheckCssResource(@QueryParameter String value) throws Exception {
        if (value == null || value.isBlank()) {
            return FormValidation.ok();
        }
        try {
            URI uri = new URI(value);
            if (!uri.isAbsolute()) {
                Path filePath = HeaderRootAction.resolvePath(value);
                if (HeaderRootAction.isNotValidPath(filePath)) {
                    return FormValidation.error((String)"Relative path must be within the \"userContent\" directory under \"JENKINS_HOME\"");
                }
            } else {
                String scheme = uri.getScheme();
                if (!scheme.equals("http") && !scheme.equals("https")) {
                    return FormValidation.error((String)"Only HTTP and HTTPS URLs are supported");
                }
            }
            return FormValidation.ok();
        }
        catch (URISyntaxException e) {
            return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
        }
    }
}

