/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.User;
import io.jenkins.plugins.customizable_header.AbstractLink;
import io.jenkins.plugins.customizable_header.AppNavLink;
import io.jenkins.plugins.customizable_header.CustomHeaderConfiguration;
import io.jenkins.plugins.customizable_header.UserHeader;
import io.jenkins.plugins.customizable_header.links.FolderLinks;
import io.jenkins.plugins.customizable_header.links.JobLinks;
import io.jenkins.plugins.customizable_header.logo.ImageLogo;
import io.jenkins.plugins.customizable_header.logo.Logo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.csp.Contributor;
import jenkins.security.csp.CspBuilder;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

@Extension
@SuppressRestrictedWarnings(value={Contributor.class, CspBuilder.class})
public class LogoContributor
implements Contributor {
    public static final Logger LOGGER = Logger.getLogger(LogoContributor.class.getName());

    public void apply(CspBuilder csp) {
        UserHeader userHeader;
        Jenkins.get().allItems(AbstractFolder.class).forEach(f -> {
            FolderLinks linksProperty = (FolderLinks)f.getProperties().get(FolderLinks.class);
            if (linksProperty == null) {
                return;
            }
            List<AbstractLink> links = linksProperty.getLinks();
            this.allowLinks(csp, links);
        });
        Jenkins.get().allItems(Job.class).forEach(j -> {
            JobProperty property = j.getProperty(JobLinks.class);
            if (property == null) {
                return;
            }
            List<AbstractLink> links = ((JobLinks)property).getLinks();
            this.allowLinks(csp, links);
        });
        User current = User.current();
        if (current != null && (userHeader = (UserHeader)current.getProperty(UserHeader.class)) != null) {
            List<AbstractLink> links = userHeader.getLinks();
            this.allowLinks(csp, links);
        }
        CustomHeaderConfiguration configuration = (CustomHeaderConfiguration)((Object)ExtensionList.lookupSingleton(CustomHeaderConfiguration.class));
        this.allowLogo(csp, configuration.getActiveLogo());
        if (Jenkins.get().hasPermission(Jenkins.READ)) {
            this.allowLinks(csp, configuration.getLinks());
        }
    }

    private void allowLinks(CspBuilder csp, List<AbstractLink> links) {
        links.stream().filter(l -> l instanceof AppNavLink).map(l -> (AppNavLink)l).map(AppNavLink::getLogo).forEach(logo -> this.allowLogo(csp, (Logo)logo));
    }

    private void allowLogo(CspBuilder csp, Logo logo) {
        String url = this.mapToLogoUrl(logo);
        if (url != null) {
            csp.add("img-src", new String[]{url});
        }
    }

    private String mapToLogoUrl(Logo logo) {
        if (logo instanceof ImageLogo) {
            ImageLogo imageLogo = (ImageLogo)logo;
            String rawUrl = imageLogo.getLogoUrl();
            if (rawUrl == null || rawUrl.isEmpty()) {
                return null;
            }
            try {
                URI uri = new URI(rawUrl);
                if (uri.isAbsolute()) {
                    return uri.toASCIIString();
                }
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.FINE, "Failed to parse URI: " + rawUrl, ex);
            }
        }
        return null;
    }
}

