/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.foldericon;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.oss.symbols.OpenSourceSymbols;
import jenkins.model.Jenkins;
import jenkins.plugins.foldericon.Messages;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class OpenSourceFolderIcon
extends FolderIcon {
    private static final String DEFAULT_ICON = "cdf-icon-color";
    private final String ossicon;
    private AbstractFolder<?> owner;

    @DataBoundConstructor
    public OpenSourceFolderIcon(String ossicon) {
        this.ossicon = StringUtils.isBlank((CharSequence)ossicon) ? DEFAULT_ICON : ossicon;
    }

    protected void setOwner(AbstractFolder<?> folder) {
        this.owner = folder;
    }

    public String getOssicon() {
        return this.ossicon;
    }

    public String getImageOf(String size) {
        return null;
    }

    public String getIconClassName() {
        return OpenSourceSymbols.getIconClassName((String)this.getOssicon());
    }

    public String getDescription() {
        if (this.owner != null) {
            return this.owner.getPronoun();
        }
        return Messages.Folder_description();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends FolderIconDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.OpenSourceFolderIcon_description();
        }
    }
}

