/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import jenkins.security.HMACConfidentialKey;
import org.springframework.security.core.Authentication;

public class Context {
    private static final HMACConfidentialKey KEY = new HMACConfidentialKey(Context.class, "key");

    private Context() {
    }

    private static String toBase64(String utf8) {
        return Base64.getUrlEncoder().encodeToString(utf8.getBytes(StandardCharsets.UTF_8));
    }

    private static String fromBase64(String b64) {
        return new String(Base64.getUrlDecoder().decode(b64), StandardCharsets.UTF_8);
    }

    public static String encodeContext(@NonNull Object ancestorName, @CheckForNull Authentication authentication, @NonNull String restOfPath) {
        String userId = authentication == null ? "" : authentication.getName();
        String encodedContext = Context.toBase64(userId) + ":" + Context.toBase64(ancestorName.toString()) + ":" + Context.toBase64(restOfPath);
        String mac = Base64.getUrlEncoder().encodeToString(KEY.mac(encodedContext.getBytes(StandardCharsets.UTF_8)));
        return mac + ":" + encodedContext;
    }

    public static DecodedContext decodeContext(String rawContext) {
        String[] macAndContext = rawContext.split(":", 2);
        if (macAndContext.length != 2) {
            throw new IllegalArgumentException("Unexpected number of split entries, expected 2, got " + macAndContext.length);
        }
        String mac = macAndContext[0];
        String encodedContext = macAndContext[1];
        if (!KEY.checkMac(encodedContext.getBytes(StandardCharsets.UTF_8), Base64.getUrlDecoder().decode(mac))) {
            throw new IllegalArgumentException("Mac check failed for " + encodedContext);
        }
        String[] encodedContextParts = encodedContext.split(":", 3);
        if (encodedContextParts.length != 3) {
            throw new IllegalArgumentException("Unexpected number of split entries, expected 3, got " + macAndContext.length);
        }
        return new DecodedContext(Context.fromBase64(encodedContextParts[0]), Context.fromBase64(encodedContextParts[1]), Context.fromBase64(encodedContextParts[2]));
    }

    public static class DecodedContext {
        public final String userId;
        public final String contextClassName;
        public final String restOfPath;

        public DecodedContext(@CheckForNull String userId, @NonNull String contextClassName, @NonNull String restOfPath) {
            this.userId = Util.fixEmpty((String)userId);
            this.contextClassName = contextClassName;
            this.restOfPath = restOfPath;
        }
    }
}

