/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.InvisibleAction;
import hudson.model.UnprotectedRootAction;
import hudson.model.User;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.HttpResponses;
import io.jenkins.plugins.csp.ContentSecurityPolicyReceiver;
import io.jenkins.plugins.csp.Context;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

@Extension
@Restricted(value={NoExternalUse.class})
@Symbol(value={"contentSecurityPolicyRootAction"})
public class ContentSecurityPolicyRootAction
extends InvisibleAction
implements UnprotectedRootAction {
    public static final String URL = "content-security-policy-reporting-endpoint";
    public static final Logger LOGGER = Logger.getLogger(ContentSecurityPolicyRootAction.class.getName());

    public String getUrlName() {
        return URL;
    }

    @POST
    public HttpResponse doDynamic(StaplerRequest2 req) {
        String restOfPath = StringUtils.removeStart((String)req.getRestOfPath(), (String)"/");
        try {
            Context.DecodedContext context = Context.decodeContext(restOfPath);
            ContentSecurityPolicyReceiver.ViewContext viewContext = new ContentSecurityPolicyReceiver.ViewContext(context.contextClassName, context.restOfPath);
            try (BufferedReader reader = req.getReader();){
                String report = IOUtils.toString((Reader)reader);
                LOGGER.log(Level.FINE, () -> String.valueOf(viewContext) + " " + report);
                JSONObject jsonObject = JSONObject.fromObject((Object)report);
                for (ContentSecurityPolicyReceiver receiver : ExtensionList.lookup(ContentSecurityPolicyReceiver.class)) {
                    try {
                        User user = context.userId == null ? null : User.getById((String)context.userId, (boolean)false);
                        receiver.report(viewContext, user, jsonObject);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, ex, () -> "Error reporting CSP to " + String.valueOf(receiver));
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e, () -> "Failed to read request body for /content-security-policy-reporting-endpoint/" + restOfPath);
            }
            return HttpResponses.ok();
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.FINE, "Unexpected rest of path failed to decode: " + restOfPath + " with exception: " + ex.getMessage());
            return HttpResponses.ok();
        }
    }

    @Extension
    public static class CrumbExclusionImpl
    extends CrumbExclusion {
        public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
            String pathInfo = request.getPathInfo();
            if (pathInfo != null && pathInfo.startsWith("/content-security-policy-reporting-endpoint/")) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            return false;
        }
    }
}

