/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.model.User;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public interface ContentSecurityPolicyReceiver
extends ExtensionPoint {
    public void report(@NonNull ViewContext var1, @CheckForNull User var2, @NonNull JSONObject var3);

    public static class ViewContext {
        private final String className;
        private final String viewName;

        public ViewContext(@NonNull String className, @NonNull String viewName) {
            this.className = Objects.requireNonNull(className, "className");
            this.viewName = Objects.requireNonNull(viewName, "viewName");
        }

        @NonNull
        public String getViewName() {
            return this.viewName;
        }

        @NonNull
        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return "Context{className='" + this.className + "', viewName='" + this.viewName + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewContext viewContext = (ViewContext)o;
            return this.className.equals(viewContext.className) && this.viewName.equals(viewContext.viewName);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.viewName);
        }
    }
}

