/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import io.jenkins.plugins.csp.ContentSecurityPolicyConfiguration;
import io.jenkins.plugins.csp.Context;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.security.ResourceDomainConfiguration;
import jenkins.util.HttpServletFilter;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

@Extension
@Restricted(value={NoExternalUse.class})
public class ContentSecurityPolicyFilter
implements HttpServletFilter {
    static String getConfiguredRules() {
        String rule = ((ContentSecurityPolicyConfiguration)((Object)ExtensionList.lookupSingleton(ContentSecurityPolicyConfiguration.class))).getRule();
        if (rule == null) {
            return null;
        }
        return StringUtils.removeEnd((String)rule.trim(), (String)";");
    }

    static String getHeader() {
        boolean reportOnly = ((ContentSecurityPolicyConfiguration)((Object)ExtensionList.lookupSingleton(ContentSecurityPolicyConfiguration.class))).isReportOnly();
        return reportOnly ? "Content-Security-Policy-Report-Only" : "Content-Security-Policy";
    }

    static String getValue(@NonNull String context) {
        String rootUrl;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && (rootUrl = jenkins.getRootUrl()) != null && jenkins.hasPermission(Jenkins.READ)) {
            return ContentSecurityPolicyFilter.getConfiguredRules() + "; report-uri " + rootUrl + "content-security-policy-reporting-endpoint/" + context;
        }
        return ContentSecurityPolicyFilter.getConfiguredRules();
    }

    @SuppressRestrictedWarnings(value={ResourceDomainConfiguration.class})
    public boolean handle(HttpServletRequest req, HttpServletResponse rsp) {
        String header = ContentSecurityPolicyFilter.getHeader();
        if (rsp.getHeader(header) == null && !ResourceDomainConfiguration.isResourceRequest((HttpServletRequest)req)) {
            String context = Context.encodeContext("", Jenkins.getAuthentication2(), StringUtils.removeStart((String)req.getRequestURI(), (String)req.getContextPath()));
            rsp.setHeader(header, ContentSecurityPolicyFilter.getValue(context));
        }
        return false;
    }
}

