/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Metric;
import hudson.model.Descriptor;
import hudson.security.Permission;
import io.jenkins.plugins.coverage.metrics.steps.CoverageAppearanceConfiguration;
import java.util.Objects;
import jenkins.model.GlobalConfigurationCategory;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;
import org.kohsuke.stapler.lang.Klass;

public class CoverageAppearanceConfigurationAssert
extends AbstractObjectAssert<CoverageAppearanceConfigurationAssert, CoverageAppearanceConfiguration> {
    public CoverageAppearanceConfigurationAssert(CoverageAppearanceConfiguration actual) {
        super((Object)actual, CoverageAppearanceConfigurationAssert.class);
    }

    @CheckReturnValue
    public static CoverageAppearanceConfigurationAssert assertThat(CoverageAppearanceConfiguration actual) {
        return new CoverageAppearanceConfigurationAssert(actual);
    }

    public CoverageAppearanceConfigurationAssert hasCategory(GlobalConfigurationCategory category) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting category of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        GlobalConfigurationCategory actualCategory = ((CoverageAppearanceConfiguration)this.actual).getCategory();
        if (!Objects.deepEquals(actualCategory, category)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, category, actualCategory});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasConfigPage(String configPage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting configPage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualConfigPage = ((CoverageAppearanceConfiguration)this.actual).getConfigPage();
        if (!Objects.deepEquals(actualConfigPage, configPage)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, configPage, actualConfigPage});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasCurrentDescriptorByNameUrl(String currentDescriptorByNameUrl) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting currentDescriptorByNameUrl of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageAppearanceConfiguration cfr_ignored_0 = (CoverageAppearanceConfiguration)this.actual;
        String actualCurrentDescriptorByNameUrl = CoverageAppearanceConfiguration.getCurrentDescriptorByNameUrl();
        if (!Objects.deepEquals(actualCurrentDescriptorByNameUrl, currentDescriptorByNameUrl)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, currentDescriptorByNameUrl, actualCurrentDescriptorByNameUrl});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasDefaultMetric(Metric defaultMetric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting defaultMetric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Metric actualDefaultMetric = ((CoverageAppearanceConfiguration)this.actual).getDefaultMetric();
        if (!Objects.deepEquals(actualDefaultMetric, defaultMetric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, defaultMetric, actualDefaultMetric});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasDefaultName(String defaultName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting defaultName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDefaultName = ((CoverageAppearanceConfiguration)this.actual).getDefaultName();
        if (!Objects.deepEquals(actualDefaultName, defaultName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, defaultName, actualDefaultName});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasDescriptor(Descriptor descriptor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting descriptor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Descriptor actualDescriptor = ((CoverageAppearanceConfiguration)this.actual).getDescriptor();
        if (!Objects.deepEquals(actualDescriptor, descriptor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, descriptor, actualDescriptor});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasDescriptorFullUrl(String descriptorFullUrl) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting descriptorFullUrl of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDescriptorFullUrl = ((CoverageAppearanceConfiguration)this.actual).getDescriptorFullUrl();
        if (!Objects.deepEquals(actualDescriptorFullUrl, descriptorFullUrl)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, descriptorFullUrl, actualDescriptorFullUrl});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasDescriptorUrl(String descriptorUrl) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting descriptorUrl of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDescriptorUrl = ((CoverageAppearanceConfiguration)this.actual).getDescriptorUrl();
        if (!Objects.deepEquals(actualDescriptorUrl, descriptorUrl)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, descriptorUrl, actualDescriptorUrl});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasDisplayName(String displayName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting displayName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDisplayName = ((CoverageAppearanceConfiguration)this.actual).getDisplayName();
        if (!Objects.deepEquals(actualDisplayName, displayName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, displayName, actualDisplayName});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert isEnableColumnByDefault() {
        this.isNotNull();
        if (!((CoverageAppearanceConfiguration)this.actual).isEnableColumnByDefault()) {
            this.failWithMessage("\nExpecting that actual CoverageAppearanceConfiguration is enable column by default but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert isNotEnableColumnByDefault() {
        this.isNotNull();
        if (((CoverageAppearanceConfiguration)this.actual).isEnableColumnByDefault()) {
            this.failWithMessage("\nExpecting that actual CoverageAppearanceConfiguration is not enable column by default but is.", new Object[0]);
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasGlobalConfigPage(String globalConfigPage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting globalConfigPage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualGlobalConfigPage = ((CoverageAppearanceConfiguration)this.actual).getGlobalConfigPage();
        if (!Objects.deepEquals(actualGlobalConfigPage, globalConfigPage)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, globalConfigPage, actualGlobalConfigPage});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasHelpFile(String helpFile) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting helpFile of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualHelpFile = ((CoverageAppearanceConfiguration)this.actual).getHelpFile();
        if (!Objects.deepEquals(actualHelpFile, helpFile)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, helpFile, actualHelpFile});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasId(String id) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualId = ((CoverageAppearanceConfiguration)this.actual).getId();
        if (!Objects.deepEquals(actualId, id)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, id, actualId});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasInstance(CoverageAppearanceConfiguration instance) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting instance of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageAppearanceConfiguration cfr_ignored_0 = (CoverageAppearanceConfiguration)this.actual;
        CoverageAppearanceConfiguration actualInstance = CoverageAppearanceConfiguration.getInstance();
        if (!Objects.deepEquals(actualInstance, instance)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, instance, actualInstance});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasJsonSafeClassName(String jsonSafeClassName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting jsonSafeClassName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualJsonSafeClassName = ((CoverageAppearanceConfiguration)this.actual).getJsonSafeClassName();
        if (!Objects.deepEquals(actualJsonSafeClassName, jsonSafeClassName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, jsonSafeClassName, actualJsonSafeClassName});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasKlass(Klass klass) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting klass of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Klass actualKlass = ((CoverageAppearanceConfiguration)this.actual).getKlass();
        if (!Objects.deepEquals(actualKlass, klass)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, klass, actualKlass});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasRequiredGlobalConfigPagePermission(Permission requiredGlobalConfigPagePermission) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting requiredGlobalConfigPagePermission of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Permission actualRequiredGlobalConfigPagePermission = ((CoverageAppearanceConfiguration)this.actual).getRequiredGlobalConfigPagePermission();
        if (!Objects.deepEquals(actualRequiredGlobalConfigPagePermission, requiredGlobalConfigPagePermission)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, requiredGlobalConfigPagePermission, actualRequiredGlobalConfigPagePermission});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasT(Class t) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting t of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Class actualT = ((CoverageAppearanceConfiguration)this.actual).getT();
        if (!Objects.deepEquals(actualT, t)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, t, actualT});
        }
        return this;
    }

    public CoverageAppearanceConfigurationAssert hasClazz(Class clazz) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting clazz of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Class actualClazz = ((CoverageAppearanceConfiguration)this.actual).clazz;
        if (!Objects.deepEquals(actualClazz, clazz)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, clazz, actualClazz});
        }
        return this;
    }
}

