/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Metric;
import hudson.model.Descriptor;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.coverage.metrics.steps.CoverageMetricColumn;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;

public class CoverageMetricColumnAssert
extends AbstractObjectAssert<CoverageMetricColumnAssert, CoverageMetricColumn> {
    public CoverageMetricColumnAssert(CoverageMetricColumn actual) {
        super((Object)actual, CoverageMetricColumnAssert.class);
    }

    @CheckReturnValue
    public static CoverageMetricColumnAssert assertThat(CoverageMetricColumn actual) {
        return new CoverageMetricColumnAssert(actual);
    }

    public CoverageMetricColumnAssert hasBaseline(Baseline baseline) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting baseline of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Baseline actualBaseline = ((CoverageMetricColumn)this.actual).getBaseline();
        if (!Objects.deepEquals(actualBaseline, baseline)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, baseline, actualBaseline});
        }
        return this;
    }

    public CoverageMetricColumnAssert hasColumnCaption(String columnCaption) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting columnCaption of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualColumnCaption = ((CoverageMetricColumn)this.actual).getColumnCaption();
        if (!Objects.deepEquals(actualColumnCaption, columnCaption)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, columnCaption, actualColumnCaption});
        }
        return this;
    }

    public CoverageMetricColumnAssert hasColumnName(String columnName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting columnName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualColumnName = ((CoverageMetricColumn)this.actual).getColumnName();
        if (!Objects.deepEquals(actualColumnName, columnName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, columnName, actualColumnName});
        }
        return this;
    }

    public CoverageMetricColumnAssert hasDescriptor(Descriptor descriptor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting descriptor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Descriptor actualDescriptor = ((CoverageMetricColumn)this.actual).getDescriptor();
        if (!Objects.deepEquals(actualDescriptor, descriptor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, descriptor, actualDescriptor});
        }
        return this;
    }

    public CoverageMetricColumnAssert hasFormatter(ElementFormatter formatter) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting formatter of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ElementFormatter actualFormatter = ((CoverageMetricColumn)this.actual).getFormatter();
        if (!Objects.deepEquals(actualFormatter, formatter)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, formatter, actualFormatter});
        }
        return this;
    }

    public CoverageMetricColumnAssert hasMetric(Metric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Metric actualMetric = ((CoverageMetricColumn)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }
}

