/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model.visualization.dashboard;

import hudson.model.Descriptor;
import io.jenkins.plugins.coverage.model.visualization.dashboard.CoverageColumn;
import io.jenkins.plugins.coverage.model.visualization.dashboard.CoverageColumnType;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;

public class CoverageColumnAssert
extends AbstractObjectAssert<CoverageColumnAssert, CoverageColumn> {
    public CoverageColumnAssert(CoverageColumn actual) {
        super((Object)actual, CoverageColumnAssert.class);
    }

    @CheckReturnValue
    public static CoverageColumnAssert assertThat(CoverageColumn actual) {
        return new CoverageColumnAssert(actual);
    }

    public CoverageColumnAssert hasColumnCaption(String columnCaption) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting columnCaption of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualColumnCaption = ((CoverageColumn)this.actual).getColumnCaption();
        if (!Objects.deepEquals(actualColumnCaption, columnCaption)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, columnCaption, actualColumnCaption});
        }
        return this;
    }

    public CoverageColumnAssert hasColumnName(String columnName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting columnName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualColumnName = ((CoverageColumn)this.actual).getColumnName();
        if (!Objects.deepEquals(actualColumnName, columnName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, columnName, actualColumnName});
        }
        return this;
    }

    public CoverageColumnAssert hasCoverageMetric(String coverageMetric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting coverageMetric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualCoverageMetric = ((CoverageColumn)this.actual).getCoverageMetric();
        if (!Objects.deepEquals(actualCoverageMetric, coverageMetric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, coverageMetric, actualCoverageMetric});
        }
        return this;
    }

    public CoverageColumnAssert hasCoverageType(String coverageType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting coverageType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualCoverageType = ((CoverageColumn)this.actual).getCoverageType();
        if (!Objects.deepEquals(actualCoverageType, coverageType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, coverageType, actualCoverageType});
        }
        return this;
    }

    public CoverageColumnAssert hasDescriptor(Descriptor descriptor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting descriptor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Descriptor actualDescriptor = ((CoverageColumn)this.actual).getDescriptor();
        if (!Objects.deepEquals(actualDescriptor, descriptor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, descriptor, actualDescriptor});
        }
        return this;
    }

    public CoverageColumnAssert hasSelectedCoverageColumnType(CoverageColumnType selectedCoverageColumnType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting selectedCoverageColumnType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageColumnType actualSelectedCoverageColumnType = ((CoverageColumn)this.actual).getSelectedCoverageColumnType();
        if (!Objects.deepEquals(actualSelectedCoverageColumnType, selectedCoverageColumnType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, selectedCoverageColumnType, actualSelectedCoverageColumnType});
        }
        return this;
    }
}

