/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model.exception;

import io.jenkins.plugins.coverage.model.exception.CodeDeltaException;
import java.util.Arrays;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;

public class CodeDeltaExceptionAssert
extends AbstractObjectAssert<CodeDeltaExceptionAssert, CodeDeltaException> {
    public CodeDeltaExceptionAssert(CodeDeltaException actual) {
        super((Object)actual, CodeDeltaExceptionAssert.class);
    }

    @CheckReturnValue
    public static CodeDeltaExceptionAssert assertThat(CodeDeltaException actual) {
        return new CodeDeltaExceptionAssert(actual);
    }

    public CodeDeltaExceptionAssert hasCause(Throwable cause) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting cause of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Throwable actualCause = ((CodeDeltaException)this.actual).getCause();
        if (!Objects.deepEquals(actualCause, cause)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, cause, actualCause});
        }
        return this;
    }

    public CodeDeltaExceptionAssert hasLocalizedMessage(String localizedMessage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting localizedMessage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualLocalizedMessage = ((CodeDeltaException)this.actual).getLocalizedMessage();
        if (!Objects.deepEquals(actualLocalizedMessage, localizedMessage)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, localizedMessage, actualLocalizedMessage});
        }
        return this;
    }

    public CodeDeltaExceptionAssert hasMessage(String message) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualMessage = ((CodeDeltaException)this.actual).getMessage();
        if (!Objects.deepEquals(actualMessage, message)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, message, actualMessage});
        }
        return this;
    }

    public CodeDeltaExceptionAssert hasStackTrace(StackTraceElement ... stackTrace) {
        this.isNotNull();
        if (stackTrace == null) {
            this.failWithMessage("Expecting stackTrace parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((Object[])((CodeDeltaException)this.actual).getStackTrace()).contains((Object[])stackTrace);
        return this;
    }

    public CodeDeltaExceptionAssert hasOnlyStackTrace(StackTraceElement ... stackTrace) {
        this.isNotNull();
        if (stackTrace == null) {
            this.failWithMessage("Expecting stackTrace parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((Object[])((CodeDeltaException)this.actual).getStackTrace()).containsOnly((Object[])stackTrace);
        return this;
    }

    public CodeDeltaExceptionAssert doesNotHaveStackTrace(StackTraceElement ... stackTrace) {
        this.isNotNull();
        if (stackTrace == null) {
            this.failWithMessage("Expecting stackTrace parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((Object[])((CodeDeltaException)this.actual).getStackTrace()).doesNotContain((Object[])stackTrace);
        return this;
    }

    public CodeDeltaExceptionAssert hasNoStackTrace() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have stackTrace but had :\n  <%s>";
        if (((CodeDeltaException)this.actual).getStackTrace().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((CodeDeltaException)this.actual).getStackTrace())});
        }
        return this;
    }

    public CodeDeltaExceptionAssert hasSuppressed(Throwable ... suppressed) {
        this.isNotNull();
        if (suppressed == null) {
            this.failWithMessage("Expecting suppressed parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((Object[])((CodeDeltaException)this.actual).getSuppressed()).contains((Object[])suppressed);
        return this;
    }

    public CodeDeltaExceptionAssert hasOnlySuppressed(Throwable ... suppressed) {
        this.isNotNull();
        if (suppressed == null) {
            this.failWithMessage("Expecting suppressed parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((Object[])((CodeDeltaException)this.actual).getSuppressed()).containsOnly((Object[])suppressed);
        return this;
    }

    public CodeDeltaExceptionAssert doesNotHaveSuppressed(Throwable ... suppressed) {
        this.isNotNull();
        if (suppressed == null) {
            this.failWithMessage("Expecting suppressed parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((Object[])((CodeDeltaException)this.actual).getSuppressed()).doesNotContain((Object[])suppressed);
        return this;
    }

    public CodeDeltaExceptionAssert hasNoSuppressed() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have suppressed but had :\n  <%s>";
        if (((CodeDeltaException)this.actual).getSuppressed().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((CodeDeltaException)this.actual).getSuppressed())});
        }
        return this;
    }
}

