/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model;

import hudson.model.Run;
import io.jenkins.plugins.coverage.model.CoverageNode;
import io.jenkins.plugins.coverage.model.CoverageViewModel;
import io.jenkins.plugins.coverage.model.SourceViewModel;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class SourceViewModelAssert
extends AbstractObjectAssert<SourceViewModelAssert, SourceViewModel> {
    public SourceViewModelAssert(SourceViewModel actual) {
        super((Object)actual, SourceViewModelAssert.class);
    }

    @CheckReturnValue
    public static SourceViewModelAssert assertThat(SourceViewModel actual) {
        return new SourceViewModelAssert(actual);
    }

    public SourceViewModelAssert hasChangeCoverage() {
        this.isNotNull();
        if (!((SourceViewModel)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual SourceViewModel has change coverage but does not have.", new Object[0]);
        }
        return this;
    }

    public SourceViewModelAssert doesNotHaveChangeCoverage() {
        this.isNotNull();
        if (((SourceViewModel)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual SourceViewModel does not have change coverage but has.", new Object[0]);
        }
        return this;
    }

    public SourceViewModelAssert hasChangeCoverageOverview(CoverageViewModel.CoverageOverview changeCoverageOverview) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting changeCoverageOverview of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageViewModel.CoverageOverview actualChangeCoverageOverview = ((SourceViewModel)this.actual).getChangeCoverageOverview();
        if (!Objects.deepEquals(actualChangeCoverageOverview, changeCoverageOverview)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, changeCoverageOverview, actualChangeCoverageOverview});
        }
        return this;
    }

    public SourceViewModelAssert hasDisplayName(String displayName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting displayName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDisplayName = ((SourceViewModel)this.actual).getDisplayName();
        if (!Objects.deepEquals(actualDisplayName, displayName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, displayName, actualDisplayName});
        }
        return this;
    }

    public SourceViewModelAssert hasId(String id) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualId = ((SourceViewModel)this.actual).getId();
        if (!Objects.deepEquals(actualId, id)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, id, actualId});
        }
        return this;
    }

    public SourceViewModelAssert hasIndirectCoverageChanges() {
        this.isNotNull();
        if (!((SourceViewModel)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual SourceViewModel has indirect coverage changes but does not have.", new Object[0]);
        }
        return this;
    }

    public SourceViewModelAssert doesNotHaveIndirectCoverageChanges() {
        this.isNotNull();
        if (((SourceViewModel)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual SourceViewModel does not have indirect coverage changes but has.", new Object[0]);
        }
        return this;
    }

    public SourceViewModelAssert hasJenkinsColorIDs(String ... jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((SourceViewModel)this.actual).getJenkinsColorIDs(), (Object[])jenkinsColorIDs);
        return this;
    }

    public SourceViewModelAssert hasJenkinsColorIDs(Collection<? extends String> jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((SourceViewModel)this.actual).getJenkinsColorIDs(), jenkinsColorIDs.toArray());
        return this;
    }

    public SourceViewModelAssert hasOnlyJenkinsColorIDs(String ... jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((SourceViewModel)this.actual).getJenkinsColorIDs(), (Object[])jenkinsColorIDs);
        return this;
    }

    public SourceViewModelAssert hasOnlyJenkinsColorIDs(Collection<? extends String> jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((SourceViewModel)this.actual).getJenkinsColorIDs(), jenkinsColorIDs.toArray());
        return this;
    }

    public SourceViewModelAssert doesNotHaveJenkinsColorIDs(String ... jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((SourceViewModel)this.actual).getJenkinsColorIDs(), (Object[])jenkinsColorIDs);
        return this;
    }

    public SourceViewModelAssert doesNotHaveJenkinsColorIDs(Collection<? extends String> jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((SourceViewModel)this.actual).getJenkinsColorIDs(), jenkinsColorIDs.toArray());
        return this;
    }

    public SourceViewModelAssert hasNoJenkinsColorIDs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have jenkinsColorIDs but had :\n  <%s>";
        if (((SourceViewModel)this.actual).getJenkinsColorIDs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((SourceViewModel)this.actual).getJenkinsColorIDs()});
        }
        return this;
    }

    public SourceViewModelAssert hasNode(CoverageNode node) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting node of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualNode = ((SourceViewModel)this.actual).getNode();
        if (!Objects.deepEquals(actualNode, node)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, node, actualNode});
        }
        return this;
    }

    public SourceViewModelAssert hasOverview(CoverageViewModel.CoverageOverview overview) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting overview of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageViewModel.CoverageOverview actualOverview = ((SourceViewModel)this.actual).getOverview();
        if (!Objects.deepEquals(actualOverview, overview)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, overview, actualOverview});
        }
        return this;
    }

    public SourceViewModelAssert hasOwner(Run owner) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting owner of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Run actualOwner = ((SourceViewModel)this.actual).getOwner();
        if (!Objects.deepEquals(actualOwner, owner)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, owner, actualOwner});
        }
        return this;
    }

    public SourceViewModelAssert hasSourceCode() {
        this.isNotNull();
        if (!((SourceViewModel)this.actual).hasSourceCode()) {
            this.failWithMessage("\nExpecting that actual SourceViewModel has source code but does not have.", new Object[0]);
        }
        return this;
    }

    public SourceViewModelAssert doesNotHaveSourceCode() {
        this.isNotNull();
        if (((SourceViewModel)this.actual).hasSourceCode()) {
            this.failWithMessage("\nExpecting that actual SourceViewModel does not have source code but has.", new Object[0]);
        }
        return this;
    }

    public SourceViewModelAssert hasSourceFileContent(String sourceFileContent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sourceFileContent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualSourceFileContent = ((SourceViewModel)this.actual).getSourceFileContent();
        if (!Objects.deepEquals(actualSourceFileContent, sourceFileContent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sourceFileContent, actualSourceFileContent});
        }
        return this;
    }
}

