/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model;

import io.jenkins.plugins.coverage.model.CoverageLeaf;
import io.jenkins.plugins.coverage.model.CoverageMetric;
import io.jenkins.plugins.coverage.model.CoverageNode;
import io.jenkins.plugins.coverage.model.FileCoverageNode;
import io.jenkins.plugins.coverage.model.PackageCoverageNode;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class PackageCoverageNodeAssert
extends AbstractObjectAssert<PackageCoverageNodeAssert, PackageCoverageNode> {
    public PackageCoverageNodeAssert(PackageCoverageNode actual) {
        super((Object)actual, PackageCoverageNodeAssert.class);
    }

    @CheckReturnValue
    public static PackageCoverageNodeAssert assertThat(PackageCoverageNode actual) {
        return new PackageCoverageNodeAssert(actual);
    }

    public PackageCoverageNodeAssert hasAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public PackageCoverageNodeAssert hasAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public PackageCoverageNodeAssert hasOnlyAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public PackageCoverageNodeAssert hasOnlyAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public PackageCoverageNodeAssert hasNoAllFileCoverageNodes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allFileCoverageNodes but had :\n  <%s>";
        if (((PackageCoverageNode)this.actual).getAllFileCoverageNodes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PackageCoverageNode)this.actual).getAllFileCoverageNodes()});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasChangeCoverage() {
        this.isNotNull();
        if (!((PackageCoverageNode)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual PackageCoverageNode has change coverage but does not have.", new Object[0]);
        }
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveChangeCoverage() {
        this.isNotNull();
        if (((PackageCoverageNode)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual PackageCoverageNode does not have change coverage but has.", new Object[0]);
        }
        return this;
    }

    public PackageCoverageNodeAssert hasChangeCoverageTree(CoverageNode changeCoverageTree) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting changeCoverageTree of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualChangeCoverageTree = ((PackageCoverageNode)this.actual).getChangeCoverageTree();
        if (!Objects.deepEquals(actualChangeCoverageTree, changeCoverageTree)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, changeCoverageTree, actualChangeCoverageTree});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public PackageCoverageNodeAssert hasChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public PackageCoverageNodeAssert hasOnlyChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public PackageCoverageNodeAssert hasOnlyChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public PackageCoverageNodeAssert hasNoChildren() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have children but had :\n  <%s>";
        if (((PackageCoverageNode)this.actual).getChildren().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PackageCoverageNode)this.actual).getChildren()});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasCodeChanges() {
        this.isNotNull();
        if (!((PackageCoverageNode)this.actual).hasCodeChanges()) {
            this.failWithMessage("\nExpecting that actual PackageCoverageNode has code changes but does not have.", new Object[0]);
        }
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveCodeChanges() {
        this.isNotNull();
        if (((PackageCoverageNode)this.actual).hasCodeChanges()) {
            this.failWithMessage("\nExpecting that actual PackageCoverageNode does not have code changes but has.", new Object[0]);
        }
        return this;
    }

    public PackageCoverageNodeAssert hasFileAmountWithChangedCoverage(int fileAmountWithChangedCoverage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileAmountWithChangedCoverage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualFileAmountWithChangedCoverage = ((PackageCoverageNode)this.actual).getFileAmountWithChangedCoverage();
        if (actualFileAmountWithChangedCoverage != fileAmountWithChangedCoverage) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileAmountWithChangedCoverage, actualFileAmountWithChangedCoverage});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasFileAmountWithIndirectCoverageChanges(int fileAmountWithIndirectCoverageChanges) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileAmountWithIndirectCoverageChanges of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualFileAmountWithIndirectCoverageChanges = ((PackageCoverageNode)this.actual).getFileAmountWithIndirectCoverageChanges();
        if (actualFileAmountWithIndirectCoverageChanges != fileAmountWithIndirectCoverageChanges) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileAmountWithIndirectCoverageChanges, actualFileAmountWithIndirectCoverageChanges});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public PackageCoverageNodeAssert hasImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public PackageCoverageNodeAssert hasOnlyImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public PackageCoverageNodeAssert hasOnlyImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public PackageCoverageNodeAssert hasNoImportantMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have importantMetrics but had :\n  <%s>";
        if (((PackageCoverageNode)this.actual).getImportantMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PackageCoverageNode)this.actual).getImportantMetrics()});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasIndirectCoverageChanges() {
        this.isNotNull();
        if (!((PackageCoverageNode)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual PackageCoverageNode has indirect coverage changes but does not have.", new Object[0]);
        }
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveIndirectCoverageChanges() {
        this.isNotNull();
        if (((PackageCoverageNode)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual PackageCoverageNode does not have indirect coverage changes but has.", new Object[0]);
        }
        return this;
    }

    public PackageCoverageNodeAssert hasIndirectCoverageChangesTree(CoverageNode indirectCoverageChangesTree) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting indirectCoverageChangesTree of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualIndirectCoverageChangesTree = ((PackageCoverageNode)this.actual).getIndirectCoverageChangesTree();
        if (!Objects.deepEquals(actualIndirectCoverageChangesTree, indirectCoverageChangesTree)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, indirectCoverageChangesTree, actualIndirectCoverageChangesTree});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public PackageCoverageNodeAssert hasLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public PackageCoverageNodeAssert hasOnlyLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public PackageCoverageNodeAssert hasOnlyLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public PackageCoverageNodeAssert hasNoLeaves() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have leaves but had :\n  <%s>";
        if (((PackageCoverageNode)this.actual).getLeaves().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PackageCoverageNode)this.actual).getLeaves()});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasLineAmountWithChangedCoverage(long lineAmountWithChangedCoverage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineAmountWithChangedCoverage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualLineAmountWithChangedCoverage = ((PackageCoverageNode)this.actual).getLineAmountWithChangedCoverage();
        if (actualLineAmountWithChangedCoverage != lineAmountWithChangedCoverage) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineAmountWithChangedCoverage, actualLineAmountWithChangedCoverage});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasLineAmountWithIndirectCoverageChanges(long lineAmountWithIndirectCoverageChanges) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineAmountWithIndirectCoverageChanges of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualLineAmountWithIndirectCoverageChanges = ((PackageCoverageNode)this.actual).getLineAmountWithIndirectCoverageChanges();
        if (actualLineAmountWithIndirectCoverageChanges != lineAmountWithIndirectCoverageChanges) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineAmountWithIndirectCoverageChanges, actualLineAmountWithIndirectCoverageChanges});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasMetric(CoverageMetric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageMetric actualMetric = ((PackageCoverageNode)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasMetricFractions(SortedMap metricFractions) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricFractions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricFractions = ((PackageCoverageNode)this.actual).getMetricFractions();
        if (!Objects.deepEquals(actualMetricFractions, metricFractions)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricFractions, actualMetricFractions});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasMetricPercentages(SortedMap metricPercentages) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricPercentages of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricPercentages = ((PackageCoverageNode)this.actual).getMetricPercentages();
        if (!Objects.deepEquals(actualMetricPercentages, metricPercentages)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricPercentages, actualMetricPercentages});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public PackageCoverageNodeAssert hasMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public PackageCoverageNodeAssert hasOnlyMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public PackageCoverageNodeAssert hasOnlyMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((PackageCoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public PackageCoverageNodeAssert hasNoMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have metrics but had :\n  <%s>";
        if (((PackageCoverageNode)this.actual).getMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PackageCoverageNode)this.actual).getMetrics()});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasMetricsDistribution(SortedMap metricsDistribution) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricsDistribution of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricsDistribution = ((PackageCoverageNode)this.actual).getMetricsDistribution();
        if (!Objects.deepEquals(actualMetricsDistribution, metricsDistribution)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricsDistribution, actualMetricsDistribution});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((PackageCoverageNode)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasParent(CoverageNode parent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualParent = ((PackageCoverageNode)this.actual).getParent();
        if (!Objects.deepEquals(actualParent, parent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parent, actualParent});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasParent() {
        this.isNotNull();
        if (!((PackageCoverageNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual PackageCoverageNode has parent but does not have.", new Object[0]);
        }
        return this;
    }

    public PackageCoverageNodeAssert doesNotHaveParent() {
        this.isNotNull();
        if (((PackageCoverageNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual PackageCoverageNode does not have parent but has.", new Object[0]);
        }
        return this;
    }

    public PackageCoverageNodeAssert hasParentName(String parentName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parentName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualParentName = ((PackageCoverageNode)this.actual).getParentName();
        if (!Objects.deepEquals(actualParentName, parentName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parentName, actualParentName});
        }
        return this;
    }

    public PackageCoverageNodeAssert hasPath(String path) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPath = ((PackageCoverageNode)this.actual).getPath();
        if (!Objects.deepEquals(actualPath, path)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, path, actualPath});
        }
        return this;
    }

    public PackageCoverageNodeAssert isRoot() {
        this.isNotNull();
        if (!((PackageCoverageNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual PackageCoverageNode is root but is not.", new Object[0]);
        }
        return this;
    }

    public PackageCoverageNodeAssert isNotRoot() {
        this.isNotNull();
        if (((PackageCoverageNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual PackageCoverageNode is not root but is.", new Object[0]);
        }
        return this;
    }
}

