/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model;

import io.jenkins.plugins.coverage.model.CoverageLeaf;
import io.jenkins.plugins.coverage.model.CoverageMetric;
import io.jenkins.plugins.coverage.model.CoverageNode;
import io.jenkins.plugins.coverage.model.FileCoverageNode;
import io.jenkins.plugins.coverage.model.MethodCoverageNode;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class MethodCoverageNodeAssert
extends AbstractObjectAssert<MethodCoverageNodeAssert, MethodCoverageNode> {
    public MethodCoverageNodeAssert(MethodCoverageNode actual) {
        super((Object)actual, MethodCoverageNodeAssert.class);
    }

    @CheckReturnValue
    public static MethodCoverageNodeAssert assertThat(MethodCoverageNode actual) {
        return new MethodCoverageNodeAssert(actual);
    }

    public MethodCoverageNodeAssert hasAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public MethodCoverageNodeAssert hasAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public MethodCoverageNodeAssert hasOnlyAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public MethodCoverageNodeAssert hasOnlyAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public MethodCoverageNodeAssert hasNoAllFileCoverageNodes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allFileCoverageNodes but had :\n  <%s>";
        if (((MethodCoverageNode)this.actual).getAllFileCoverageNodes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MethodCoverageNode)this.actual).getAllFileCoverageNodes()});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasChangeCoverage() {
        this.isNotNull();
        if (!((MethodCoverageNode)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode has change coverage but does not have.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveChangeCoverage() {
        this.isNotNull();
        if (((MethodCoverageNode)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode does not have change coverage but has.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert hasChangeCoverageTree(CoverageNode changeCoverageTree) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting changeCoverageTree of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualChangeCoverageTree = ((MethodCoverageNode)this.actual).getChangeCoverageTree();
        if (!Objects.deepEquals(actualChangeCoverageTree, changeCoverageTree)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, changeCoverageTree, actualChangeCoverageTree});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public MethodCoverageNodeAssert hasChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public MethodCoverageNodeAssert hasOnlyChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public MethodCoverageNodeAssert hasOnlyChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public MethodCoverageNodeAssert hasNoChildren() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have children but had :\n  <%s>";
        if (((MethodCoverageNode)this.actual).getChildren().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MethodCoverageNode)this.actual).getChildren()});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasCodeChanges() {
        this.isNotNull();
        if (!((MethodCoverageNode)this.actual).hasCodeChanges()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode has code changes but does not have.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveCodeChanges() {
        this.isNotNull();
        if (((MethodCoverageNode)this.actual).hasCodeChanges()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode does not have code changes but has.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert hasFileAmountWithChangedCoverage(int fileAmountWithChangedCoverage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileAmountWithChangedCoverage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualFileAmountWithChangedCoverage = ((MethodCoverageNode)this.actual).getFileAmountWithChangedCoverage();
        if (actualFileAmountWithChangedCoverage != fileAmountWithChangedCoverage) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileAmountWithChangedCoverage, actualFileAmountWithChangedCoverage});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasFileAmountWithIndirectCoverageChanges(int fileAmountWithIndirectCoverageChanges) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileAmountWithIndirectCoverageChanges of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualFileAmountWithIndirectCoverageChanges = ((MethodCoverageNode)this.actual).getFileAmountWithIndirectCoverageChanges();
        if (actualFileAmountWithIndirectCoverageChanges != fileAmountWithIndirectCoverageChanges) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileAmountWithIndirectCoverageChanges, actualFileAmountWithIndirectCoverageChanges});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public MethodCoverageNodeAssert hasImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public MethodCoverageNodeAssert hasOnlyImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public MethodCoverageNodeAssert hasOnlyImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public MethodCoverageNodeAssert hasNoImportantMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have importantMetrics but had :\n  <%s>";
        if (((MethodCoverageNode)this.actual).getImportantMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MethodCoverageNode)this.actual).getImportantMetrics()});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasIndirectCoverageChanges() {
        this.isNotNull();
        if (!((MethodCoverageNode)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode has indirect coverage changes but does not have.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveIndirectCoverageChanges() {
        this.isNotNull();
        if (((MethodCoverageNode)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode does not have indirect coverage changes but has.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert hasIndirectCoverageChangesTree(CoverageNode indirectCoverageChangesTree) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting indirectCoverageChangesTree of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualIndirectCoverageChangesTree = ((MethodCoverageNode)this.actual).getIndirectCoverageChangesTree();
        if (!Objects.deepEquals(actualIndirectCoverageChangesTree, indirectCoverageChangesTree)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, indirectCoverageChangesTree, actualIndirectCoverageChangesTree});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public MethodCoverageNodeAssert hasLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public MethodCoverageNodeAssert hasOnlyLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public MethodCoverageNodeAssert hasOnlyLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public MethodCoverageNodeAssert hasNoLeaves() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have leaves but had :\n  <%s>";
        if (((MethodCoverageNode)this.actual).getLeaves().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MethodCoverageNode)this.actual).getLeaves()});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasLineAmountWithChangedCoverage(long lineAmountWithChangedCoverage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineAmountWithChangedCoverage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualLineAmountWithChangedCoverage = ((MethodCoverageNode)this.actual).getLineAmountWithChangedCoverage();
        if (actualLineAmountWithChangedCoverage != lineAmountWithChangedCoverage) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineAmountWithChangedCoverage, actualLineAmountWithChangedCoverage});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasLineAmountWithIndirectCoverageChanges(long lineAmountWithIndirectCoverageChanges) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineAmountWithIndirectCoverageChanges of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualLineAmountWithIndirectCoverageChanges = ((MethodCoverageNode)this.actual).getLineAmountWithIndirectCoverageChanges();
        if (actualLineAmountWithIndirectCoverageChanges != lineAmountWithIndirectCoverageChanges) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineAmountWithIndirectCoverageChanges, actualLineAmountWithIndirectCoverageChanges});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasLineNumber(int lineNumber) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineNumber of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualLineNumber = ((MethodCoverageNode)this.actual).getLineNumber();
        if (actualLineNumber != lineNumber) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineNumber, actualLineNumber});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasMetric(CoverageMetric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageMetric actualMetric = ((MethodCoverageNode)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasMetricFractions(SortedMap metricFractions) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricFractions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricFractions = ((MethodCoverageNode)this.actual).getMetricFractions();
        if (!Objects.deepEquals(actualMetricFractions, metricFractions)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricFractions, actualMetricFractions});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasMetricPercentages(SortedMap metricPercentages) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricPercentages of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricPercentages = ((MethodCoverageNode)this.actual).getMetricPercentages();
        if (!Objects.deepEquals(actualMetricPercentages, metricPercentages)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricPercentages, actualMetricPercentages});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public MethodCoverageNodeAssert hasMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public MethodCoverageNodeAssert hasOnlyMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public MethodCoverageNodeAssert hasOnlyMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MethodCoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public MethodCoverageNodeAssert hasNoMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have metrics but had :\n  <%s>";
        if (((MethodCoverageNode)this.actual).getMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MethodCoverageNode)this.actual).getMetrics()});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasMetricsDistribution(SortedMap metricsDistribution) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricsDistribution of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricsDistribution = ((MethodCoverageNode)this.actual).getMetricsDistribution();
        if (!Objects.deepEquals(actualMetricsDistribution, metricsDistribution)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricsDistribution, actualMetricsDistribution});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((MethodCoverageNode)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasParent(CoverageNode parent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualParent = ((MethodCoverageNode)this.actual).getParent();
        if (!Objects.deepEquals(actualParent, parent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parent, actualParent});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasParent() {
        this.isNotNull();
        if (!((MethodCoverageNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode has parent but does not have.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveParent() {
        this.isNotNull();
        if (((MethodCoverageNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode does not have parent but has.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert hasParentName(String parentName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parentName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualParentName = ((MethodCoverageNode)this.actual).getParentName();
        if (!Objects.deepEquals(actualParentName, parentName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parentName, actualParentName});
        }
        return this;
    }

    public MethodCoverageNodeAssert hasPath(String path) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPath = ((MethodCoverageNode)this.actual).getPath();
        if (!Objects.deepEquals(actualPath, path)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, path, actualPath});
        }
        return this;
    }

    public MethodCoverageNodeAssert isRoot() {
        this.isNotNull();
        if (!((MethodCoverageNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode is root but is not.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert isNotRoot() {
        this.isNotNull();
        if (((MethodCoverageNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode is not root but is.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert hasValidLineNumber() {
        this.isNotNull();
        if (!((MethodCoverageNode)this.actual).hasValidLineNumber()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode has valid line number but does not have.", new Object[0]);
        }
        return this;
    }

    public MethodCoverageNodeAssert doesNotHaveValidLineNumber() {
        this.isNotNull();
        if (((MethodCoverageNode)this.actual).hasValidLineNumber()) {
            this.failWithMessage("\nExpecting that actual MethodCoverageNode does not have valid line number but has.", new Object[0]);
        }
        return this;
    }
}

