/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model;

import hudson.model.Run;
import io.jenkins.plugins.coverage.model.CoverageNode;
import io.jenkins.plugins.coverage.model.CoverageViewModel;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class CoverageViewModelAssert
extends AbstractObjectAssert<CoverageViewModelAssert, CoverageViewModel> {
    public CoverageViewModelAssert(CoverageViewModel actual) {
        super((Object)actual, CoverageViewModelAssert.class);
    }

    @CheckReturnValue
    public static CoverageViewModelAssert assertThat(CoverageViewModel actual) {
        return new CoverageViewModelAssert(actual);
    }

    public CoverageViewModelAssert hasChangeCoverage() {
        this.isNotNull();
        if (!((CoverageViewModel)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel has change coverage but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert doesNotHaveChangeCoverage() {
        this.isNotNull();
        if (((CoverageViewModel)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel does not have change coverage but has.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert hasChangeCoverageOverview(CoverageViewModel.CoverageOverview changeCoverageOverview) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting changeCoverageOverview of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageViewModel.CoverageOverview actualChangeCoverageOverview = ((CoverageViewModel)this.actual).getChangeCoverageOverview();
        if (!Objects.deepEquals(actualChangeCoverageOverview, changeCoverageOverview)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, changeCoverageOverview, actualChangeCoverageOverview});
        }
        return this;
    }

    public CoverageViewModelAssert hasDisplayName(String displayName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting displayName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDisplayName = ((CoverageViewModel)this.actual).getDisplayName();
        if (!Objects.deepEquals(actualDisplayName, displayName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, displayName, actualDisplayName});
        }
        return this;
    }

    public CoverageViewModelAssert hasId(String id) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualId = ((CoverageViewModel)this.actual).getId();
        if (!Objects.deepEquals(actualId, id)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, id, actualId});
        }
        return this;
    }

    public CoverageViewModelAssert hasIndirectCoverageChanges() {
        this.isNotNull();
        if (!((CoverageViewModel)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel has indirect coverage changes but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert doesNotHaveIndirectCoverageChanges() {
        this.isNotNull();
        if (((CoverageViewModel)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel does not have indirect coverage changes but has.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert hasJenkinsColorIDs(String ... jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), (Object[])jenkinsColorIDs);
        return this;
    }

    public CoverageViewModelAssert hasJenkinsColorIDs(Collection<? extends String> jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), jenkinsColorIDs.toArray());
        return this;
    }

    public CoverageViewModelAssert hasOnlyJenkinsColorIDs(String ... jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), (Object[])jenkinsColorIDs);
        return this;
    }

    public CoverageViewModelAssert hasOnlyJenkinsColorIDs(Collection<? extends String> jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), jenkinsColorIDs.toArray());
        return this;
    }

    public CoverageViewModelAssert doesNotHaveJenkinsColorIDs(String ... jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), (Object[])jenkinsColorIDs);
        return this;
    }

    public CoverageViewModelAssert doesNotHaveJenkinsColorIDs(Collection<? extends String> jenkinsColorIDs) {
        this.isNotNull();
        if (jenkinsColorIDs == null) {
            this.failWithMessage("Expecting jenkinsColorIDs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageViewModel)this.actual).getJenkinsColorIDs(), jenkinsColorIDs.toArray());
        return this;
    }

    public CoverageViewModelAssert hasNoJenkinsColorIDs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have jenkinsColorIDs but had :\n  <%s>";
        if (((CoverageViewModel)this.actual).getJenkinsColorIDs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageViewModel)this.actual).getJenkinsColorIDs()});
        }
        return this;
    }

    public CoverageViewModelAssert hasNode(CoverageNode node) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting node of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualNode = ((CoverageViewModel)this.actual).getNode();
        if (!Objects.deepEquals(actualNode, node)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, node, actualNode});
        }
        return this;
    }

    public CoverageViewModelAssert hasOverview(CoverageViewModel.CoverageOverview overview) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting overview of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageViewModel.CoverageOverview actualOverview = ((CoverageViewModel)this.actual).getOverview();
        if (!Objects.deepEquals(actualOverview, overview)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, overview, actualOverview});
        }
        return this;
    }

    public CoverageViewModelAssert hasOwner(Run owner) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting owner of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Run actualOwner = ((CoverageViewModel)this.actual).getOwner();
        if (!Objects.deepEquals(actualOwner, owner)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, owner, actualOwner});
        }
        return this;
    }

    public CoverageViewModelAssert hasSourceCode() {
        this.isNotNull();
        if (!((CoverageViewModel)this.actual).hasSourceCode()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel has source code but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageViewModelAssert doesNotHaveSourceCode() {
        this.isNotNull();
        if (((CoverageViewModel)this.actual).hasSourceCode()) {
            this.failWithMessage("\nExpecting that actual CoverageViewModel does not have source code but has.", new Object[0]);
        }
        return this;
    }
}

