/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model;

import io.jenkins.plugins.coverage.model.CoverageLeaf;
import io.jenkins.plugins.coverage.model.CoverageMetric;
import io.jenkins.plugins.coverage.model.CoverageNode;
import io.jenkins.plugins.coverage.model.FileCoverageNode;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class CoverageNodeAssert
extends AbstractObjectAssert<CoverageNodeAssert, CoverageNode> {
    public CoverageNodeAssert(CoverageNode actual) {
        super((Object)actual, CoverageNodeAssert.class);
    }

    @CheckReturnValue
    public static CoverageNodeAssert assertThat(CoverageNode actual) {
        return new CoverageNodeAssert(actual);
    }

    public CoverageNodeAssert hasAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public CoverageNodeAssert hasAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public CoverageNodeAssert hasOnlyAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public CoverageNodeAssert hasOnlyAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public CoverageNodeAssert doesNotHaveAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public CoverageNodeAssert doesNotHaveAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public CoverageNodeAssert hasNoAllFileCoverageNodes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allFileCoverageNodes but had :\n  <%s>";
        if (((CoverageNode)this.actual).getAllFileCoverageNodes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageNode)this.actual).getAllFileCoverageNodes()});
        }
        return this;
    }

    public CoverageNodeAssert hasChangeCoverage() {
        this.isNotNull();
        if (!((CoverageNode)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual CoverageNode has change coverage but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageNodeAssert doesNotHaveChangeCoverage() {
        this.isNotNull();
        if (((CoverageNode)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual CoverageNode does not have change coverage but has.", new Object[0]);
        }
        return this;
    }

    public CoverageNodeAssert hasChangeCoverageTree(CoverageNode changeCoverageTree) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting changeCoverageTree of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualChangeCoverageTree = ((CoverageNode)this.actual).getChangeCoverageTree();
        if (!Objects.deepEquals(actualChangeCoverageTree, changeCoverageTree)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, changeCoverageTree, actualChangeCoverageTree});
        }
        return this;
    }

    public CoverageNodeAssert hasChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public CoverageNodeAssert hasChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public CoverageNodeAssert hasOnlyChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public CoverageNodeAssert hasOnlyChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public CoverageNodeAssert doesNotHaveChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public CoverageNodeAssert doesNotHaveChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public CoverageNodeAssert hasNoChildren() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have children but had :\n  <%s>";
        if (((CoverageNode)this.actual).getChildren().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageNode)this.actual).getChildren()});
        }
        return this;
    }

    public CoverageNodeAssert hasCodeChanges() {
        this.isNotNull();
        if (!((CoverageNode)this.actual).hasCodeChanges()) {
            this.failWithMessage("\nExpecting that actual CoverageNode has code changes but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageNodeAssert doesNotHaveCodeChanges() {
        this.isNotNull();
        if (((CoverageNode)this.actual).hasCodeChanges()) {
            this.failWithMessage("\nExpecting that actual CoverageNode does not have code changes but has.", new Object[0]);
        }
        return this;
    }

    public CoverageNodeAssert hasFileAmountWithChangedCoverage(int fileAmountWithChangedCoverage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileAmountWithChangedCoverage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualFileAmountWithChangedCoverage = ((CoverageNode)this.actual).getFileAmountWithChangedCoverage();
        if (actualFileAmountWithChangedCoverage != fileAmountWithChangedCoverage) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileAmountWithChangedCoverage, actualFileAmountWithChangedCoverage});
        }
        return this;
    }

    public CoverageNodeAssert hasFileAmountWithIndirectCoverageChanges(int fileAmountWithIndirectCoverageChanges) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileAmountWithIndirectCoverageChanges of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualFileAmountWithIndirectCoverageChanges = ((CoverageNode)this.actual).getFileAmountWithIndirectCoverageChanges();
        if (actualFileAmountWithIndirectCoverageChanges != fileAmountWithIndirectCoverageChanges) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileAmountWithIndirectCoverageChanges, actualFileAmountWithIndirectCoverageChanges});
        }
        return this;
    }

    public CoverageNodeAssert hasImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public CoverageNodeAssert hasImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public CoverageNodeAssert hasOnlyImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public CoverageNodeAssert hasOnlyImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public CoverageNodeAssert doesNotHaveImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public CoverageNodeAssert doesNotHaveImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public CoverageNodeAssert hasNoImportantMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have importantMetrics but had :\n  <%s>";
        if (((CoverageNode)this.actual).getImportantMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageNode)this.actual).getImportantMetrics()});
        }
        return this;
    }

    public CoverageNodeAssert hasIndirectCoverageChanges() {
        this.isNotNull();
        if (!((CoverageNode)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual CoverageNode has indirect coverage changes but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageNodeAssert doesNotHaveIndirectCoverageChanges() {
        this.isNotNull();
        if (((CoverageNode)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual CoverageNode does not have indirect coverage changes but has.", new Object[0]);
        }
        return this;
    }

    public CoverageNodeAssert hasIndirectCoverageChangesTree(CoverageNode indirectCoverageChangesTree) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting indirectCoverageChangesTree of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualIndirectCoverageChangesTree = ((CoverageNode)this.actual).getIndirectCoverageChangesTree();
        if (!Objects.deepEquals(actualIndirectCoverageChangesTree, indirectCoverageChangesTree)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, indirectCoverageChangesTree, actualIndirectCoverageChangesTree});
        }
        return this;
    }

    public CoverageNodeAssert hasLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public CoverageNodeAssert hasLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public CoverageNodeAssert hasOnlyLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public CoverageNodeAssert hasOnlyLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public CoverageNodeAssert doesNotHaveLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public CoverageNodeAssert doesNotHaveLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public CoverageNodeAssert hasNoLeaves() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have leaves but had :\n  <%s>";
        if (((CoverageNode)this.actual).getLeaves().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageNode)this.actual).getLeaves()});
        }
        return this;
    }

    public CoverageNodeAssert hasLineAmountWithChangedCoverage(long lineAmountWithChangedCoverage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineAmountWithChangedCoverage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualLineAmountWithChangedCoverage = ((CoverageNode)this.actual).getLineAmountWithChangedCoverage();
        if (actualLineAmountWithChangedCoverage != lineAmountWithChangedCoverage) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineAmountWithChangedCoverage, actualLineAmountWithChangedCoverage});
        }
        return this;
    }

    public CoverageNodeAssert hasLineAmountWithIndirectCoverageChanges(long lineAmountWithIndirectCoverageChanges) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineAmountWithIndirectCoverageChanges of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualLineAmountWithIndirectCoverageChanges = ((CoverageNode)this.actual).getLineAmountWithIndirectCoverageChanges();
        if (actualLineAmountWithIndirectCoverageChanges != lineAmountWithIndirectCoverageChanges) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineAmountWithIndirectCoverageChanges, actualLineAmountWithIndirectCoverageChanges});
        }
        return this;
    }

    public CoverageNodeAssert hasMetric(CoverageMetric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageMetric actualMetric = ((CoverageNode)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }

    public CoverageNodeAssert hasMetricFractions(SortedMap metricFractions) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricFractions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricFractions = ((CoverageNode)this.actual).getMetricFractions();
        if (!Objects.deepEquals(actualMetricFractions, metricFractions)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricFractions, actualMetricFractions});
        }
        return this;
    }

    public CoverageNodeAssert hasMetricPercentages(SortedMap metricPercentages) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricPercentages of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricPercentages = ((CoverageNode)this.actual).getMetricPercentages();
        if (!Objects.deepEquals(actualMetricPercentages, metricPercentages)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricPercentages, actualMetricPercentages});
        }
        return this;
    }

    public CoverageNodeAssert hasMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public CoverageNodeAssert hasMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public CoverageNodeAssert hasOnlyMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public CoverageNodeAssert hasOnlyMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public CoverageNodeAssert doesNotHaveMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public CoverageNodeAssert doesNotHaveMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public CoverageNodeAssert hasNoMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have metrics but had :\n  <%s>";
        if (((CoverageNode)this.actual).getMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageNode)this.actual).getMetrics()});
        }
        return this;
    }

    public CoverageNodeAssert hasMetricsDistribution(SortedMap metricsDistribution) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricsDistribution of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricsDistribution = ((CoverageNode)this.actual).getMetricsDistribution();
        if (!Objects.deepEquals(actualMetricsDistribution, metricsDistribution)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricsDistribution, actualMetricsDistribution});
        }
        return this;
    }

    public CoverageNodeAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((CoverageNode)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public CoverageNodeAssert hasParent(CoverageNode parent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualParent = ((CoverageNode)this.actual).getParent();
        if (!Objects.deepEquals(actualParent, parent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parent, actualParent});
        }
        return this;
    }

    public CoverageNodeAssert hasParent() {
        this.isNotNull();
        if (!((CoverageNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual CoverageNode has parent but does not have.", new Object[0]);
        }
        return this;
    }

    public CoverageNodeAssert doesNotHaveParent() {
        this.isNotNull();
        if (((CoverageNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual CoverageNode does not have parent but has.", new Object[0]);
        }
        return this;
    }

    public CoverageNodeAssert hasParentName(String parentName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parentName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualParentName = ((CoverageNode)this.actual).getParentName();
        if (!Objects.deepEquals(actualParentName, parentName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parentName, actualParentName});
        }
        return this;
    }

    public CoverageNodeAssert hasPath(String path) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPath = ((CoverageNode)this.actual).getPath();
        if (!Objects.deepEquals(actualPath, path)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, path, actualPath});
        }
        return this;
    }

    public CoverageNodeAssert isRoot() {
        this.isNotNull();
        if (!((CoverageNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual CoverageNode is root but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageNodeAssert isNotRoot() {
        this.isNotNull();
        if (((CoverageNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual CoverageNode is not root but is.", new Object[0]);
        }
        return this;
    }
}

