/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model;

import io.jenkins.plugins.coverage.model.Coverage;
import io.jenkins.plugins.coverage.model.CoveragePercentage;
import java.util.Objects;
import org.apache.commons.lang3.math.Fraction;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;

public class CoverageAssert
extends AbstractObjectAssert<CoverageAssert, Coverage> {
    public CoverageAssert(Coverage actual) {
        super((Object)actual, CoverageAssert.class);
    }

    @CheckReturnValue
    public static CoverageAssert assertThat(Coverage actual) {
        return new CoverageAssert(actual);
    }

    public CoverageAssert hasCovered(int covered) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting covered of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualCovered = ((Coverage)this.actual).getCovered();
        if (actualCovered != covered) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, covered, actualCovered});
        }
        return this;
    }

    public CoverageAssert hasCoveredFraction(Fraction coveredFraction) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting coveredFraction of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Fraction actualCoveredFraction = ((Coverage)this.actual).getCoveredFraction();
        if (!Objects.deepEquals(actualCoveredFraction, coveredFraction)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, coveredFraction, actualCoveredFraction});
        }
        return this;
    }

    public CoverageAssert hasCoveredPercentage(CoveragePercentage coveredPercentage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting coveredPercentage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoveragePercentage actualCoveredPercentage = ((Coverage)this.actual).getCoveredPercentage();
        if (!Objects.deepEquals(actualCoveredPercentage, coveredPercentage)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, coveredPercentage, actualCoveredPercentage});
        }
        return this;
    }

    public CoverageAssert hasMissed(int missed) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting missed of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualMissed = ((Coverage)this.actual).getMissed();
        if (actualMissed != missed) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, missed, actualMissed});
        }
        return this;
    }

    public CoverageAssert hasMissedFraction(Fraction missedFraction) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting missedFraction of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Fraction actualMissedFraction = ((Coverage)this.actual).getMissedFraction();
        if (!Objects.deepEquals(actualMissedFraction, missedFraction)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, missedFraction, actualMissedFraction});
        }
        return this;
    }

    public CoverageAssert hasMissedPercentage(CoveragePercentage missedPercentage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting missedPercentage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoveragePercentage actualMissedPercentage = ((Coverage)this.actual).getMissedPercentage();
        if (!Objects.deepEquals(actualMissedPercentage, missedPercentage)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, missedPercentage, actualMissedPercentage});
        }
        return this;
    }

    public CoverageAssert hasRoundedPercentage(int roundedPercentage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting roundedPercentage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualRoundedPercentage = ((Coverage)this.actual).getRoundedPercentage();
        if (actualRoundedPercentage != roundedPercentage) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, roundedPercentage, actualRoundedPercentage});
        }
        return this;
    }

    public CoverageAssert isSet() {
        this.isNotNull();
        if (!((Coverage)this.actual).isSet()) {
            this.failWithMessage("\nExpecting that actual Coverage is set but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageAssert isNotSet() {
        this.isNotNull();
        if (((Coverage)this.actual).isSet()) {
            this.failWithMessage("\nExpecting that actual Coverage is not set but is.", new Object[0]);
        }
        return this;
    }

    public CoverageAssert hasTotal(int total) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting total of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualTotal = ((Coverage)this.actual).getTotal();
        if (actualTotal != total) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, total, actualTotal});
        }
        return this;
    }
}

