/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model.visualization.dashboard;

import io.jenkins.plugins.coverage.model.visualization.dashboard.CoverageColumnType;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class CoverageColumnTypeAssert
extends AbstractObjectAssert<CoverageColumnTypeAssert, CoverageColumnType> {
    public CoverageColumnTypeAssert(CoverageColumnType actual) {
        super((Object)actual, CoverageColumnTypeAssert.class);
    }

    @CheckReturnValue
    public static CoverageColumnTypeAssert assertThat(CoverageColumnType actual) {
        return new CoverageColumnTypeAssert(actual);
    }

    public CoverageColumnTypeAssert hasAnchor(String anchor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting anchor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualAnchor = ((CoverageColumnType)this.actual).getAnchor();
        if (!Objects.deepEquals(actualAnchor, anchor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, anchor, actualAnchor});
        }
        return this;
    }

    public CoverageColumnTypeAssert hasAvailableCoverageTypeNames(String ... availableCoverageTypeNames) {
        this.isNotNull();
        if (availableCoverageTypeNames == null) {
            this.failWithMessage("Expecting availableCoverageTypeNames parameter not to be null.", new Object[0]);
        }
        CoverageColumnType cfr_ignored_0 = (CoverageColumnType)this.actual;
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)CoverageColumnType.getAvailableCoverageTypeNames(), (Object[])availableCoverageTypeNames);
        return this;
    }

    public CoverageColumnTypeAssert hasAvailableCoverageTypeNames(Collection<? extends String> availableCoverageTypeNames) {
        this.isNotNull();
        if (availableCoverageTypeNames == null) {
            this.failWithMessage("Expecting availableCoverageTypeNames parameter not to be null.", new Object[0]);
            return this;
        }
        CoverageColumnType cfr_ignored_0 = (CoverageColumnType)this.actual;
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)CoverageColumnType.getAvailableCoverageTypeNames(), availableCoverageTypeNames.toArray());
        return this;
    }

    public CoverageColumnTypeAssert hasOnlyAvailableCoverageTypeNames(String ... availableCoverageTypeNames) {
        this.isNotNull();
        if (availableCoverageTypeNames == null) {
            this.failWithMessage("Expecting availableCoverageTypeNames parameter not to be null.", new Object[0]);
        }
        CoverageColumnType cfr_ignored_0 = (CoverageColumnType)this.actual;
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)CoverageColumnType.getAvailableCoverageTypeNames(), (Object[])availableCoverageTypeNames);
        return this;
    }

    public CoverageColumnTypeAssert hasOnlyAvailableCoverageTypeNames(Collection<? extends String> availableCoverageTypeNames) {
        this.isNotNull();
        if (availableCoverageTypeNames == null) {
            this.failWithMessage("Expecting availableCoverageTypeNames parameter not to be null.", new Object[0]);
            return this;
        }
        CoverageColumnType cfr_ignored_0 = (CoverageColumnType)this.actual;
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)CoverageColumnType.getAvailableCoverageTypeNames(), availableCoverageTypeNames.toArray());
        return this;
    }

    public CoverageColumnTypeAssert doesNotHaveAvailableCoverageTypeNames(String ... availableCoverageTypeNames) {
        this.isNotNull();
        if (availableCoverageTypeNames == null) {
            this.failWithMessage("Expecting availableCoverageTypeNames parameter not to be null.", new Object[0]);
        }
        CoverageColumnType cfr_ignored_0 = (CoverageColumnType)this.actual;
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)CoverageColumnType.getAvailableCoverageTypeNames(), (Object[])availableCoverageTypeNames);
        return this;
    }

    public CoverageColumnTypeAssert doesNotHaveAvailableCoverageTypeNames(Collection<? extends String> availableCoverageTypeNames) {
        this.isNotNull();
        if (availableCoverageTypeNames == null) {
            this.failWithMessage("Expecting availableCoverageTypeNames parameter not to be null.", new Object[0]);
            return this;
        }
        CoverageColumnType cfr_ignored_0 = (CoverageColumnType)this.actual;
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)CoverageColumnType.getAvailableCoverageTypeNames(), availableCoverageTypeNames.toArray());
        return this;
    }

    public CoverageColumnTypeAssert hasNoAvailableCoverageTypeNames() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have availableCoverageTypeNames but had :\n  <%s>";
        CoverageColumnType cfr_ignored_0 = (CoverageColumnType)this.actual;
        if (CoverageColumnType.getAvailableCoverageTypeNames().iterator().hasNext()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.actual;
            CoverageColumnType cfr_ignored_1 = (CoverageColumnType)this.actual;
            objectArray[1] = CoverageColumnType.getAvailableCoverageTypeNames();
            this.failWithMessage(assertjErrorMessage, objectArray);
        }
        return this;
    }

    public CoverageColumnTypeAssert hasDisplayName(String displayName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting displayName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDisplayName = ((CoverageColumnType)this.actual).getDisplayName();
        if (!Objects.deepEquals(actualDisplayName, displayName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, displayName, actualDisplayName});
        }
        return this;
    }
}

