/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model;

import io.jenkins.plugins.coverage.model.CoverageLeaf;
import io.jenkins.plugins.coverage.model.CoverageMetric;
import io.jenkins.plugins.coverage.model.CoverageNode;
import io.jenkins.plugins.coverage.model.FileCoverageNode;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class FileCoverageNodeAssert
extends AbstractObjectAssert<FileCoverageNodeAssert, FileCoverageNode> {
    public FileCoverageNodeAssert(FileCoverageNode actual) {
        super((Object)actual, FileCoverageNodeAssert.class);
    }

    @CheckReturnValue
    public static FileCoverageNodeAssert assertThat(FileCoverageNode actual) {
        return new FileCoverageNodeAssert(actual);
    }

    public FileCoverageNodeAssert hasAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public FileCoverageNodeAssert hasAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasOnlyAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public FileCoverageNodeAssert hasOnlyAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveAllFileCoverageNodes(FileCoverageNode ... allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getAllFileCoverageNodes(), (Object[])allFileCoverageNodes);
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveAllFileCoverageNodes(Collection<? extends FileCoverageNode> allFileCoverageNodes) {
        this.isNotNull();
        if (allFileCoverageNodes == null) {
            this.failWithMessage("Expecting allFileCoverageNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getAllFileCoverageNodes(), allFileCoverageNodes.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasNoAllFileCoverageNodes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allFileCoverageNodes but had :\n  <%s>";
        if (((FileCoverageNode)this.actual).getAllFileCoverageNodes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((FileCoverageNode)this.actual).getAllFileCoverageNodes()});
        }
        return this;
    }

    public FileCoverageNodeAssert hasChangeCoverage() {
        this.isNotNull();
        if (!((FileCoverageNode)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual FileCoverageNode has change coverage but does not have.", new Object[0]);
        }
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveChangeCoverage() {
        this.isNotNull();
        if (((FileCoverageNode)this.actual).hasChangeCoverage()) {
            this.failWithMessage("\nExpecting that actual FileCoverageNode does not have change coverage but has.", new Object[0]);
        }
        return this;
    }

    public FileCoverageNodeAssert hasChangeCoverageTree(CoverageNode changeCoverageTree) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting changeCoverageTree of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualChangeCoverageTree = ((FileCoverageNode)this.actual).getChangeCoverageTree();
        if (!Objects.deepEquals(actualChangeCoverageTree, changeCoverageTree)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, changeCoverageTree, actualChangeCoverageTree});
        }
        return this;
    }

    public FileCoverageNodeAssert hasChangedCodeLines(Integer ... changedCodeLines) {
        this.isNotNull();
        if (changedCodeLines == null) {
            this.failWithMessage("Expecting changedCodeLines parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChangedCodeLines(), (Object[])changedCodeLines);
        return this;
    }

    public FileCoverageNodeAssert hasChangedCodeLines(Collection<? extends Integer> changedCodeLines) {
        this.isNotNull();
        if (changedCodeLines == null) {
            this.failWithMessage("Expecting changedCodeLines parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChangedCodeLines(), changedCodeLines.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasOnlyChangedCodeLines(Integer ... changedCodeLines) {
        this.isNotNull();
        if (changedCodeLines == null) {
            this.failWithMessage("Expecting changedCodeLines parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChangedCodeLines(), (Object[])changedCodeLines);
        return this;
    }

    public FileCoverageNodeAssert hasOnlyChangedCodeLines(Collection<? extends Integer> changedCodeLines) {
        this.isNotNull();
        if (changedCodeLines == null) {
            this.failWithMessage("Expecting changedCodeLines parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChangedCodeLines(), changedCodeLines.toArray());
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveChangedCodeLines(Integer ... changedCodeLines) {
        this.isNotNull();
        if (changedCodeLines == null) {
            this.failWithMessage("Expecting changedCodeLines parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChangedCodeLines(), (Object[])changedCodeLines);
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveChangedCodeLines(Collection<? extends Integer> changedCodeLines) {
        this.isNotNull();
        if (changedCodeLines == null) {
            this.failWithMessage("Expecting changedCodeLines parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChangedCodeLines(), changedCodeLines.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasNoChangedCodeLines() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have changedCodeLines but had :\n  <%s>";
        if (((FileCoverageNode)this.actual).getChangedCodeLines().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((FileCoverageNode)this.actual).getChangedCodeLines()});
        }
        return this;
    }

    public FileCoverageNodeAssert hasChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public FileCoverageNodeAssert hasChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasOnlyChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public FileCoverageNodeAssert hasOnlyChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveChildren(CoverageNode ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveChildren(Collection<? extends CoverageNode> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasNoChildren() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have children but had :\n  <%s>";
        if (((FileCoverageNode)this.actual).getChildren().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((FileCoverageNode)this.actual).getChildren()});
        }
        return this;
    }

    public FileCoverageNodeAssert hasCodeChanges() {
        this.isNotNull();
        if (!((FileCoverageNode)this.actual).hasCodeChanges()) {
            this.failWithMessage("\nExpecting that actual FileCoverageNode has code changes but does not have.", new Object[0]);
        }
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveCodeChanges() {
        this.isNotNull();
        if (((FileCoverageNode)this.actual).hasCodeChanges()) {
            this.failWithMessage("\nExpecting that actual FileCoverageNode does not have code changes but has.", new Object[0]);
        }
        return this;
    }

    public FileCoverageNodeAssert hasCoveragePerLine(SortedMap coveragePerLine) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting coveragePerLine of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualCoveragePerLine = ((FileCoverageNode)this.actual).getCoveragePerLine();
        if (!Objects.deepEquals(actualCoveragePerLine, coveragePerLine)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, coveragePerLine, actualCoveragePerLine});
        }
        return this;
    }

    public FileCoverageNodeAssert hasFileAmountWithChangedCoverage(int fileAmountWithChangedCoverage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileAmountWithChangedCoverage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualFileAmountWithChangedCoverage = ((FileCoverageNode)this.actual).getFileAmountWithChangedCoverage();
        if (actualFileAmountWithChangedCoverage != fileAmountWithChangedCoverage) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileAmountWithChangedCoverage, actualFileAmountWithChangedCoverage});
        }
        return this;
    }

    public FileCoverageNodeAssert hasFileAmountWithIndirectCoverageChanges(int fileAmountWithIndirectCoverageChanges) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileAmountWithIndirectCoverageChanges of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualFileAmountWithIndirectCoverageChanges = ((FileCoverageNode)this.actual).getFileAmountWithIndirectCoverageChanges();
        if (actualFileAmountWithIndirectCoverageChanges != fileAmountWithIndirectCoverageChanges) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileAmountWithIndirectCoverageChanges, actualFileAmountWithIndirectCoverageChanges});
        }
        return this;
    }

    public FileCoverageNodeAssert hasImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public FileCoverageNodeAssert hasImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasOnlyImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public FileCoverageNodeAssert hasOnlyImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveImportantMetrics(CoverageMetric ... importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getImportantMetrics(), (Object[])importantMetrics);
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveImportantMetrics(Collection<? extends CoverageMetric> importantMetrics) {
        this.isNotNull();
        if (importantMetrics == null) {
            this.failWithMessage("Expecting importantMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getImportantMetrics(), importantMetrics.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasNoImportantMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have importantMetrics but had :\n  <%s>";
        if (((FileCoverageNode)this.actual).getImportantMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((FileCoverageNode)this.actual).getImportantMetrics()});
        }
        return this;
    }

    public FileCoverageNodeAssert hasIndirectCoverageChanges(SortedMap indirectCoverageChanges) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting indirectCoverageChanges of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualIndirectCoverageChanges = ((FileCoverageNode)this.actual).getIndirectCoverageChanges();
        if (!Objects.deepEquals(actualIndirectCoverageChanges, indirectCoverageChanges)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, indirectCoverageChanges, actualIndirectCoverageChanges});
        }
        return this;
    }

    public FileCoverageNodeAssert hasIndirectCoverageChanges() {
        this.isNotNull();
        if (!((FileCoverageNode)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual FileCoverageNode has indirect coverage changes but does not have.", new Object[0]);
        }
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveIndirectCoverageChanges() {
        this.isNotNull();
        if (((FileCoverageNode)this.actual).hasIndirectCoverageChanges()) {
            this.failWithMessage("\nExpecting that actual FileCoverageNode does not have indirect coverage changes but has.", new Object[0]);
        }
        return this;
    }

    public FileCoverageNodeAssert hasIndirectCoverageChangesTree(CoverageNode indirectCoverageChangesTree) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting indirectCoverageChangesTree of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualIndirectCoverageChangesTree = ((FileCoverageNode)this.actual).getIndirectCoverageChangesTree();
        if (!Objects.deepEquals(actualIndirectCoverageChangesTree, indirectCoverageChangesTree)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, indirectCoverageChangesTree, actualIndirectCoverageChangesTree});
        }
        return this;
    }

    public FileCoverageNodeAssert hasLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public FileCoverageNodeAssert hasLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasOnlyLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public FileCoverageNodeAssert hasOnlyLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveLeaves(CoverageLeaf ... leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getLeaves(), (Object[])leaves);
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveLeaves(Collection<? extends CoverageLeaf> leaves) {
        this.isNotNull();
        if (leaves == null) {
            this.failWithMessage("Expecting leaves parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getLeaves(), leaves.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasNoLeaves() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have leaves but had :\n  <%s>";
        if (((FileCoverageNode)this.actual).getLeaves().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((FileCoverageNode)this.actual).getLeaves()});
        }
        return this;
    }

    public FileCoverageNodeAssert hasLineAmountWithChangedCoverage(long lineAmountWithChangedCoverage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineAmountWithChangedCoverage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualLineAmountWithChangedCoverage = ((FileCoverageNode)this.actual).getLineAmountWithChangedCoverage();
        if (actualLineAmountWithChangedCoverage != lineAmountWithChangedCoverage) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineAmountWithChangedCoverage, actualLineAmountWithChangedCoverage});
        }
        return this;
    }

    public FileCoverageNodeAssert hasLineAmountWithIndirectCoverageChanges(long lineAmountWithIndirectCoverageChanges) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineAmountWithIndirectCoverageChanges of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualLineAmountWithIndirectCoverageChanges = ((FileCoverageNode)this.actual).getLineAmountWithIndirectCoverageChanges();
        if (actualLineAmountWithIndirectCoverageChanges != lineAmountWithIndirectCoverageChanges) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineAmountWithIndirectCoverageChanges, actualLineAmountWithIndirectCoverageChanges});
        }
        return this;
    }

    public FileCoverageNodeAssert hasMetric(CoverageMetric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageMetric actualMetric = ((FileCoverageNode)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }

    public FileCoverageNodeAssert hasMetricFractions(SortedMap metricFractions) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricFractions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricFractions = ((FileCoverageNode)this.actual).getMetricFractions();
        if (!Objects.deepEquals(actualMetricFractions, metricFractions)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricFractions, actualMetricFractions});
        }
        return this;
    }

    public FileCoverageNodeAssert hasMetricPercentages(SortedMap metricPercentages) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricPercentages of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricPercentages = ((FileCoverageNode)this.actual).getMetricPercentages();
        if (!Objects.deepEquals(actualMetricPercentages, metricPercentages)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricPercentages, actualMetricPercentages});
        }
        return this;
    }

    public FileCoverageNodeAssert hasMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public FileCoverageNodeAssert hasMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasOnlyMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public FileCoverageNodeAssert hasOnlyMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveMetrics(CoverageMetric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveMetrics(Collection<? extends CoverageMetric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((FileCoverageNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public FileCoverageNodeAssert hasNoMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have metrics but had :\n  <%s>";
        if (((FileCoverageNode)this.actual).getMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((FileCoverageNode)this.actual).getMetrics()});
        }
        return this;
    }

    public FileCoverageNodeAssert hasMetricsDistribution(SortedMap metricsDistribution) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricsDistribution of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SortedMap actualMetricsDistribution = ((FileCoverageNode)this.actual).getMetricsDistribution();
        if (!Objects.deepEquals(actualMetricsDistribution, metricsDistribution)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricsDistribution, actualMetricsDistribution});
        }
        return this;
    }

    public FileCoverageNodeAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((FileCoverageNode)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public FileCoverageNodeAssert hasParent(CoverageNode parent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageNode actualParent = ((FileCoverageNode)this.actual).getParent();
        if (!Objects.deepEquals(actualParent, parent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parent, actualParent});
        }
        return this;
    }

    public FileCoverageNodeAssert hasParent() {
        this.isNotNull();
        if (!((FileCoverageNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual FileCoverageNode has parent but does not have.", new Object[0]);
        }
        return this;
    }

    public FileCoverageNodeAssert doesNotHaveParent() {
        this.isNotNull();
        if (((FileCoverageNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual FileCoverageNode does not have parent but has.", new Object[0]);
        }
        return this;
    }

    public FileCoverageNodeAssert hasParentName(String parentName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parentName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualParentName = ((FileCoverageNode)this.actual).getParentName();
        if (!Objects.deepEquals(actualParentName, parentName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parentName, actualParentName});
        }
        return this;
    }

    public FileCoverageNodeAssert hasPath(String path) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPath = ((FileCoverageNode)this.actual).getPath();
        if (!Objects.deepEquals(actualPath, path)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, path, actualPath});
        }
        return this;
    }

    public FileCoverageNodeAssert isRoot() {
        this.isNotNull();
        if (!((FileCoverageNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual FileCoverageNode is root but is not.", new Object[0]);
        }
        return this;
    }

    public FileCoverageNodeAssert isNotRoot() {
        this.isNotNull();
        if (((FileCoverageNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual FileCoverageNode is not root but is.", new Object[0]);
        }
        return this;
    }
}

