/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model;

import io.jenkins.plugins.coverage.model.CoveragePercentage;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;

public class CoveragePercentageAssert
extends AbstractObjectAssert<CoveragePercentageAssert, CoveragePercentage> {
    public CoveragePercentageAssert(CoveragePercentage actual) {
        super((Object)actual, CoveragePercentageAssert.class);
    }

    @CheckReturnValue
    public static CoveragePercentageAssert assertThat(CoveragePercentage actual) {
        return new CoveragePercentageAssert(actual);
    }

    public CoveragePercentageAssert hasDenominator(int denominator) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting denominator of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualDenominator = ((CoveragePercentage)this.actual).getDenominator();
        if (actualDenominator != denominator) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, denominator, actualDenominator});
        }
        return this;
    }

    public CoveragePercentageAssert hasDoubleValue(double doubleValue) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting doubleValue of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        double actualDoubleValue = ((CoveragePercentage)this.actual).getDoubleValue();
        if (actualDoubleValue != doubleValue) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, doubleValue, actualDoubleValue});
        }
        return this;
    }

    public CoveragePercentageAssert hasDoubleValueCloseTo(double doubleValue, double assertjOffset) {
        this.isNotNull();
        double actualDoubleValue = ((CoveragePercentage)this.actual).getDoubleValue();
        String assertjErrorMessage = String.format("\nExpecting doubleValue:\n  <%s>\nto be close to:\n  <%s>\nby less than <%s> but difference was <%s>", actualDoubleValue, doubleValue, assertjOffset, Math.abs(doubleValue - actualDoubleValue));
        ((AbstractDoubleAssert)Assertions.assertThat((double)actualDoubleValue).overridingErrorMessage(assertjErrorMessage, new Object[0])).isCloseTo(doubleValue, Assertions.within((Double)assertjOffset));
        return this;
    }

    public CoveragePercentageAssert hasNumerator(int numerator) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting numerator of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualNumerator = ((CoveragePercentage)this.actual).getNumerator();
        if (actualNumerator != numerator) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, numerator, actualNumerator});
        }
        return this;
    }
}

