/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.model;

import io.jenkins.plugins.coverage.model.CoverageMetric;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class CoverageMetricAssert
extends AbstractComparableAssert<CoverageMetricAssert, CoverageMetric> {
    public CoverageMetricAssert(CoverageMetric actual) {
        super((Comparable)actual, CoverageMetricAssert.class);
    }

    @CheckReturnValue
    public static CoverageMetricAssert assertThat(CoverageMetric actual) {
        return new CoverageMetricAssert(actual);
    }

    public CoverageMetricAssert hasAvailableCoverageMetrics(CoverageMetric ... availableCoverageMetrics) {
        this.isNotNull();
        if (availableCoverageMetrics == null) {
            this.failWithMessage("Expecting availableCoverageMetrics parameter not to be null.", new Object[0]);
        }
        CoverageMetric cfr_ignored_0 = (CoverageMetric)this.actual;
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)CoverageMetric.getAvailableCoverageMetrics(), (Object[])availableCoverageMetrics);
        return this;
    }

    public CoverageMetricAssert hasAvailableCoverageMetrics(Collection<? extends CoverageMetric> availableCoverageMetrics) {
        this.isNotNull();
        if (availableCoverageMetrics == null) {
            this.failWithMessage("Expecting availableCoverageMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        CoverageMetric cfr_ignored_0 = (CoverageMetric)this.actual;
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)CoverageMetric.getAvailableCoverageMetrics(), availableCoverageMetrics.toArray());
        return this;
    }

    public CoverageMetricAssert hasOnlyAvailableCoverageMetrics(CoverageMetric ... availableCoverageMetrics) {
        this.isNotNull();
        if (availableCoverageMetrics == null) {
            this.failWithMessage("Expecting availableCoverageMetrics parameter not to be null.", new Object[0]);
        }
        CoverageMetric cfr_ignored_0 = (CoverageMetric)this.actual;
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)CoverageMetric.getAvailableCoverageMetrics(), (Object[])availableCoverageMetrics);
        return this;
    }

    public CoverageMetricAssert hasOnlyAvailableCoverageMetrics(Collection<? extends CoverageMetric> availableCoverageMetrics) {
        this.isNotNull();
        if (availableCoverageMetrics == null) {
            this.failWithMessage("Expecting availableCoverageMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        CoverageMetric cfr_ignored_0 = (CoverageMetric)this.actual;
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)CoverageMetric.getAvailableCoverageMetrics(), availableCoverageMetrics.toArray());
        return this;
    }

    public CoverageMetricAssert doesNotHaveAvailableCoverageMetrics(CoverageMetric ... availableCoverageMetrics) {
        this.isNotNull();
        if (availableCoverageMetrics == null) {
            this.failWithMessage("Expecting availableCoverageMetrics parameter not to be null.", new Object[0]);
        }
        CoverageMetric cfr_ignored_0 = (CoverageMetric)this.actual;
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)CoverageMetric.getAvailableCoverageMetrics(), (Object[])availableCoverageMetrics);
        return this;
    }

    public CoverageMetricAssert doesNotHaveAvailableCoverageMetrics(Collection<? extends CoverageMetric> availableCoverageMetrics) {
        this.isNotNull();
        if (availableCoverageMetrics == null) {
            this.failWithMessage("Expecting availableCoverageMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        CoverageMetric cfr_ignored_0 = (CoverageMetric)this.actual;
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)CoverageMetric.getAvailableCoverageMetrics(), availableCoverageMetrics.toArray());
        return this;
    }

    public CoverageMetricAssert hasNoAvailableCoverageMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have availableCoverageMetrics but had :\n  <%s>";
        CoverageMetric cfr_ignored_0 = (CoverageMetric)this.actual;
        if (CoverageMetric.getAvailableCoverageMetrics().iterator().hasNext()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.actual;
            CoverageMetric cfr_ignored_1 = (CoverageMetric)this.actual;
            objectArray[1] = CoverageMetric.getAvailableCoverageMetrics();
            this.failWithMessage(assertjErrorMessage, objectArray);
        }
        return this;
    }

    public CoverageMetricAssert isLeaf() {
        this.isNotNull();
        if (!((CoverageMetric)this.actual).isLeaf()) {
            this.failWithMessage("\nExpecting that actual CoverageMetric is leaf but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageMetricAssert isNotLeaf() {
        this.isNotNull();
        if (((CoverageMetric)this.actual).isLeaf()) {
            this.failWithMessage("\nExpecting that actual CoverageMetric is not leaf but is.", new Object[0]);
        }
        return this;
    }

    public CoverageMetricAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((CoverageMetric)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }
}

