/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import hudson.model.Descriptor;
import io.jenkins.plugins.coverage.metrics.steps.CoverageQualityGate;
import io.jenkins.plugins.coverage.metrics.steps.CoverageRecorder;
import io.jenkins.plugins.coverage.metrics.steps.CoverageStep;
import io.jenkins.plugins.coverage.metrics.steps.CoverageTool;
import io.jenkins.plugins.prism.SourceCodeDirectory;
import io.jenkins.plugins.prism.SourceCodeRetention;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public class CoverageStepAssert
extends AbstractObjectAssert<CoverageStepAssert, CoverageStep> {
    public CoverageStepAssert(CoverageStep actual) {
        super((Object)actual, CoverageStepAssert.class);
    }

    @CheckReturnValue
    public static CoverageStepAssert assertThat(CoverageStep actual) {
        return new CoverageStepAssert(actual);
    }

    public CoverageStepAssert hasChecksAnnotationScope(CoverageRecorder.ChecksAnnotationScope checksAnnotationScope) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting checksAnnotationScope of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageRecorder.ChecksAnnotationScope actualChecksAnnotationScope = ((CoverageStep)this.actual).getChecksAnnotationScope();
        if (!Objects.deepEquals(actualChecksAnnotationScope, checksAnnotationScope)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, checksAnnotationScope, actualChecksAnnotationScope});
        }
        return this;
    }

    public CoverageStepAssert hasChecksName(String checksName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting checksName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualChecksName = ((CoverageStep)this.actual).getChecksName();
        if (!Objects.deepEquals(actualChecksName, checksName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, checksName, actualChecksName});
        }
        return this;
    }

    public CoverageStepAssert hasDescriptor(Descriptor descriptor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting descriptor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        StepDescriptor actualDescriptor = ((CoverageStep)this.actual).getDescriptor();
        if (!Objects.deepEquals(actualDescriptor, descriptor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, descriptor, actualDescriptor});
        }
        return this;
    }

    public CoverageStepAssert isEnabledForFailure() {
        this.isNotNull();
        if (!((CoverageStep)this.actual).isEnabledForFailure()) {
            this.failWithMessage("\nExpecting that actual CoverageStep is enabled for failure but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageStepAssert isNotEnabledForFailure() {
        this.isNotNull();
        if (((CoverageStep)this.actual).isEnabledForFailure()) {
            this.failWithMessage("\nExpecting that actual CoverageStep is not enabled for failure but is.", new Object[0]);
        }
        return this;
    }

    public CoverageStepAssert isFailOnError() {
        this.isNotNull();
        if (!((CoverageStep)this.actual).isFailOnError()) {
            this.failWithMessage("\nExpecting that actual CoverageStep is fail on error but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageStepAssert isNotFailOnError() {
        this.isNotNull();
        if (((CoverageStep)this.actual).isFailOnError()) {
            this.failWithMessage("\nExpecting that actual CoverageStep is not fail on error but is.", new Object[0]);
        }
        return this;
    }

    public CoverageStepAssert hasId(String id) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualId = ((CoverageStep)this.actual).getId();
        if (!Objects.deepEquals(actualId, id)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, id, actualId});
        }
        return this;
    }

    public CoverageStepAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((CoverageStep)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public CoverageStepAssert hasQualityGates(CoverageQualityGate ... qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getQualityGates(), (Object[])qualityGates);
        return this;
    }

    public CoverageStepAssert hasQualityGates(Collection<? extends CoverageQualityGate> qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getQualityGates(), qualityGates.toArray());
        return this;
    }

    public CoverageStepAssert hasOnlyQualityGates(CoverageQualityGate ... qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getQualityGates(), (Object[])qualityGates);
        return this;
    }

    public CoverageStepAssert hasOnlyQualityGates(Collection<? extends CoverageQualityGate> qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getQualityGates(), qualityGates.toArray());
        return this;
    }

    public CoverageStepAssert doesNotHaveQualityGates(CoverageQualityGate ... qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getQualityGates(), (Object[])qualityGates);
        return this;
    }

    public CoverageStepAssert doesNotHaveQualityGates(Collection<? extends CoverageQualityGate> qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getQualityGates(), qualityGates.toArray());
        return this;
    }

    public CoverageStepAssert hasNoQualityGates() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have qualityGates but had :\n  <%s>";
        if (((CoverageStep)this.actual).getQualityGates().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageStep)this.actual).getQualityGates()});
        }
        return this;
    }

    public CoverageStepAssert hasScm(String scm) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting scm of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualScm = ((CoverageStep)this.actual).getScm();
        if (!Objects.deepEquals(actualScm, scm)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, scm, actualScm});
        }
        return this;
    }

    public CoverageStepAssert isSkipPublishingChecks() {
        this.isNotNull();
        if (!((CoverageStep)this.actual).isSkipPublishingChecks()) {
            this.failWithMessage("\nExpecting that actual CoverageStep is skip publishing checks but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageStepAssert isNotSkipPublishingChecks() {
        this.isNotNull();
        if (((CoverageStep)this.actual).isSkipPublishingChecks()) {
            this.failWithMessage("\nExpecting that actual CoverageStep is not skip publishing checks but is.", new Object[0]);
        }
        return this;
    }

    public CoverageStepAssert isSkipSymbolicLinks() {
        this.isNotNull();
        if (!((CoverageStep)this.actual).isSkipSymbolicLinks()) {
            this.failWithMessage("\nExpecting that actual CoverageStep is skip symbolic links but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageStepAssert isNotSkipSymbolicLinks() {
        this.isNotNull();
        if (((CoverageStep)this.actual).isSkipSymbolicLinks()) {
            this.failWithMessage("\nExpecting that actual CoverageStep is not skip symbolic links but is.", new Object[0]);
        }
        return this;
    }

    public CoverageStepAssert hasSourceCodeEncoding(String sourceCodeEncoding) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sourceCodeEncoding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualSourceCodeEncoding = ((CoverageStep)this.actual).getSourceCodeEncoding();
        if (!Objects.deepEquals(actualSourceCodeEncoding, sourceCodeEncoding)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sourceCodeEncoding, actualSourceCodeEncoding});
        }
        return this;
    }

    public CoverageStepAssert hasSourceCodeRetention(SourceCodeRetention sourceCodeRetention) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sourceCodeRetention of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SourceCodeRetention actualSourceCodeRetention = ((CoverageStep)this.actual).getSourceCodeRetention();
        if (!Objects.deepEquals(actualSourceCodeRetention, sourceCodeRetention)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sourceCodeRetention, actualSourceCodeRetention});
        }
        return this;
    }

    public CoverageStepAssert hasSourceDirectories(SourceCodeDirectory ... sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getSourceDirectories(), (Object[])sourceDirectories);
        return this;
    }

    public CoverageStepAssert hasSourceDirectories(Collection<? extends SourceCodeDirectory> sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getSourceDirectories(), sourceDirectories.toArray());
        return this;
    }

    public CoverageStepAssert hasOnlySourceDirectories(SourceCodeDirectory ... sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getSourceDirectories(), (Object[])sourceDirectories);
        return this;
    }

    public CoverageStepAssert hasOnlySourceDirectories(Collection<? extends SourceCodeDirectory> sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getSourceDirectories(), sourceDirectories.toArray());
        return this;
    }

    public CoverageStepAssert doesNotHaveSourceDirectories(SourceCodeDirectory ... sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getSourceDirectories(), (Object[])sourceDirectories);
        return this;
    }

    public CoverageStepAssert doesNotHaveSourceDirectories(Collection<? extends SourceCodeDirectory> sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getSourceDirectories(), sourceDirectories.toArray());
        return this;
    }

    public CoverageStepAssert hasNoSourceDirectories() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have sourceDirectories but had :\n  <%s>";
        if (((CoverageStep)this.actual).getSourceDirectories().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageStep)this.actual).getSourceDirectories()});
        }
        return this;
    }

    public CoverageStepAssert hasTools(CoverageTool ... tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getTools(), (Object[])tools);
        return this;
    }

    public CoverageStepAssert hasTools(Collection<? extends CoverageTool> tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getTools(), tools.toArray());
        return this;
    }

    public CoverageStepAssert hasOnlyTools(CoverageTool ... tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getTools(), (Object[])tools);
        return this;
    }

    public CoverageStepAssert hasOnlyTools(Collection<? extends CoverageTool> tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getTools(), tools.toArray());
        return this;
    }

    public CoverageStepAssert doesNotHaveTools(CoverageTool ... tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getTools(), (Object[])tools);
        return this;
    }

    public CoverageStepAssert doesNotHaveTools(Collection<? extends CoverageTool> tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageStep)this.actual).getTools(), tools.toArray());
        return this;
    }

    public CoverageStepAssert hasNoTools() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have tools but had :\n  <%s>";
        if (((CoverageStep)this.actual).getTools().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageStep)this.actual).getTools()});
        }
        return this;
    }
}

