// CHECKSTYLE:OFF

package io.jenkins.plugins.coverage.source;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code SourceFileResolver.saveLast}: {@code save last build source
     * files}.
     * 
     * @return
     *     {@code save last build source files}
     */
    public static String SourceFileResolver_saveLast() {
        return holder.format("SourceFileResolver.saveLast");
    }

    /**
     * Key {@code SourceFileResolver.saveLast}: {@code save last build source
     * files}.
     * 
     * @return
     *     {@code save last build source files}
     */
    public static Localizable _SourceFileResolver_saveLast() {
        return new Localizable(holder, "SourceFileResolver.saveLast");
    }

    /**
     * Key {@code SourceFileResolver.saveAll}: {@code save all build source
     * files}.
     * 
     * @return
     *     {@code save all build source files}
     */
    public static String SourceFileResolver_saveAll() {
        return holder.format("SourceFileResolver.saveAll");
    }

    /**
     * Key {@code SourceFileResolver.saveAll}: {@code save all build source
     * files}.
     * 
     * @return
     *     {@code save all build source files}
     */
    public static Localizable _SourceFileResolver_saveAll() {
        return new Localizable(holder, "SourceFileResolver.saveAll");
    }

    /**
     * Key {@code SourceFileResolver.neverSave}: {@code never save source
     * files}.
     * 
     * @return
     *     {@code never save source files}
     */
    public static String SourceFileResolver_neverSave() {
        return holder.format("SourceFileResolver.neverSave");
    }

    /**
     * Key {@code SourceFileResolver.neverSave}: {@code never save source
     * files}.
     * 
     * @return
     *     {@code never save source files}
     */
    public static Localizable _SourceFileResolver_neverSave() {
        return new Localizable(holder, "SourceFileResolver.neverSave");
    }

}
