// CHECKSTYLE:OFF

package io.jenkins.plugins.coverage.model;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Project_Coverage_Delta_Type}: {@code Project Coverage
     * Delta}.
     * 
     * @return
     *     {@code Project Coverage Delta}
     */
    public static String Project_Coverage_Delta_Type() {
        return holder.format("Project_Coverage_Delta_Type");
    }

    /**
     * Key {@code Project_Coverage_Delta_Type}: {@code Project Coverage
     * Delta}.
     * 
     * @return
     *     {@code Project Coverage Delta}
     */
    public static Localizable _Project_Coverage_Delta_Type() {
        return new Localizable(holder, "Project_Coverage_Delta_Type");
    }

    /**
     * Key {@code Column.DeltaBranchCoverage}: {@code Branch {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Branch {0}}
     */
    public static String Column_DeltaBranchCoverage(Object arg0) {
        return holder.format("Column.DeltaBranchCoverage", arg0);
    }

    /**
     * Key {@code Column.DeltaBranchCoverage}: {@code Branch {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Branch {0}}
     */
    public static Localizable _Column_DeltaBranchCoverage(Object arg0) {
        return new Localizable(holder, "Column.DeltaBranchCoverage", arg0);
    }

    /**
     * Key {@code Column.LinesOfCode}: {@code LOC}.
     * 
     * @return
     *     {@code LOC}
     */
    public static String Column_LinesOfCode() {
        return holder.format("Column.LinesOfCode");
    }

    /**
     * Key {@code Column.LinesOfCode}: {@code LOC}.
     * 
     * @return
     *     {@code LOC}
     */
    public static Localizable _Column_LinesOfCode() {
        return new Localizable(holder, "Column.LinesOfCode");
    }

    /**
     * Key {@code Column.BranchCoverage}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static String Column_BranchCoverage() {
        return holder.format("Column.BranchCoverage");
    }

    /**
     * Key {@code Column.BranchCoverage}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static Localizable _Column_BranchCoverage() {
        return new Localizable(holder, "Column.BranchCoverage");
    }

    /**
     * Key {@code Coverage.Not.Available}: {@code n/a}.
     * 
     * @return
     *     {@code n/a}
     */
    public static String Coverage_Not_Available() {
        return holder.format("Coverage.Not.Available");
    }

    /**
     * Key {@code Coverage.Not.Available}: {@code n/a}.
     * 
     * @return
     *     {@code n/a}
     */
    public static Localizable _Coverage_Not_Available() {
        return new Localizable(holder, "Coverage.Not.Available");
    }

    /**
     * Key {@code Change_Coverage_Type}: {@code Change Coverage}.
     * 
     * @return
     *     {@code Change Coverage}
     */
    public static String Change_Coverage_Type() {
        return holder.format("Change_Coverage_Type");
    }

    /**
     * Key {@code Change_Coverage_Type}: {@code Change Coverage}.
     * 
     * @return
     *     {@code Change Coverage}
     */
    public static Localizable _Change_Coverage_Type() {
        return new Localizable(holder, "Change_Coverage_Type");
    }

    /**
     * Key {@code Project_Coverage_Type}: {@code Project Coverage}.
     * 
     * @return
     *     {@code Project Coverage}
     */
    public static String Project_Coverage_Type() {
        return holder.format("Project_Coverage_Type");
    }

    /**
     * Key {@code Project_Coverage_Type}: {@code Project Coverage}.
     * 
     * @return
     *     {@code Project Coverage}
     */
    public static Localizable _Project_Coverage_Type() {
        return new Localizable(holder, "Project_Coverage_Type");
    }

    /**
     * Key {@code Coverage.Title}: {@code Coverage of ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage of ''{0}''}
     */
    public static String Coverage_Title(Object arg0) {
        return holder.format("Coverage.Title", arg0);
    }

    /**
     * Key {@code Coverage.Title}: {@code Coverage of ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage of ''{0}''}
     */
    public static Localizable _Coverage_Title(Object arg0) {
        return new Localizable(holder, "Coverage.Title", arg0);
    }

    /**
     * Key {@code Column.DeltaLineCoverage}: {@code Line {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Line {0}}
     */
    public static String Column_DeltaLineCoverage(Object arg0) {
        return holder.format("Column.DeltaLineCoverage", arg0);
    }

    /**
     * Key {@code Column.DeltaLineCoverage}: {@code Line {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Line {0}}
     */
    public static Localizable _Column_DeltaLineCoverage(Object arg0) {
        return new Localizable(holder, "Column.DeltaLineCoverage", arg0);
    }

    /**
     * Key {@code Indirect_Coverage_Changes_Type}: {@code Indirect Coverage
     * Changes}.
     * 
     * @return
     *     {@code Indirect Coverage Changes}
     */
    public static String Indirect_Coverage_Changes_Type() {
        return holder.format("Indirect_Coverage_Changes_Type");
    }

    /**
     * Key {@code Indirect_Coverage_Changes_Type}: {@code Indirect Coverage
     * Changes}.
     * 
     * @return
     *     {@code Indirect Coverage Changes}
     */
    public static Localizable _Indirect_Coverage_Changes_Type() {
        return new Localizable(holder, "Indirect_Coverage_Changes_Type");
    }

    /**
     * Key {@code Column.File}: {@code File}.
     * 
     * @return
     *     {@code File}
     */
    public static String Column_File() {
        return holder.format("Column.File");
    }

    /**
     * Key {@code Column.File}: {@code File}.
     * 
     * @return
     *     {@code File}
     */
    public static Localizable _Column_File() {
        return new Localizable(holder, "Column.File");
    }

    /**
     * Key {@code Coverage.Link.Name}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static String Coverage_Link_Name() {
        return holder.format("Coverage.Link.Name");
    }

    /**
     * Key {@code Coverage.Link.Name}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static Localizable _Coverage_Link_Name() {
        return new Localizable(holder, "Coverage.Link.Name");
    }

    /**
     * Key {@code Column.LineCoverage}: {@code Line}.
     * 
     * @return
     *     {@code Line}
     */
    public static String Column_LineCoverage() {
        return holder.format("Column.LineCoverage");
    }

    /**
     * Key {@code Column.LineCoverage}: {@code Line}.
     * 
     * @return
     *     {@code Line}
     */
    public static Localizable _Column_LineCoverage() {
        return new Localizable(holder, "Column.LineCoverage");
    }

    /**
     * Key {@code Coverage_Column}: {@code Coverage}.
     * 
     * @return
     *     {@code Coverage}
     */
    public static String Coverage_Column() {
        return holder.format("Coverage_Column");
    }

    /**
     * Key {@code Coverage_Column}: {@code Coverage}.
     * 
     * @return
     *     {@code Coverage}
     */
    public static Localizable _Coverage_Column() {
        return new Localizable(holder, "Coverage_Column");
    }

    /**
     * Key {@code Change_Coverage_Delta_Type}: {@code Change Coverage Delta}.
     * 
     * @return
     *     {@code Change Coverage Delta}
     */
    public static String Change_Coverage_Delta_Type() {
        return holder.format("Change_Coverage_Delta_Type");
    }

    /**
     * Key {@code Change_Coverage_Delta_Type}: {@code Change Coverage Delta}.
     * 
     * @return
     *     {@code Change Coverage Delta}
     */
    public static Localizable _Change_Coverage_Delta_Type() {
        return new Localizable(holder, "Change_Coverage_Delta_Type");
    }

    /**
     * Key {@code Column.Package}: {@code Package}.
     * 
     * @return
     *     {@code Package}
     */
    public static String Column_Package() {
        return holder.format("Column.Package");
    }

    /**
     * Key {@code Column.Package}: {@code Package}.
     * 
     * @return
     *     {@code Package}
     */
    public static Localizable _Column_Package() {
        return new Localizable(holder, "Column.Package");
    }

}
