// CHECKSTYLE:OFF

package io.jenkins.plugins.coverage;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code CoverageColumn.Caption}: {@code Line Coverage}.
     * 
     * @return
     *     {@code Line Coverage}
     */
    public static String CoverageColumn_Caption() {
        return holder.format("CoverageColumn.Caption");
    }

    /**
     * Key {@code CoverageColumn.Caption}: {@code Line Coverage}.
     * 
     * @return
     *     {@code Line Coverage}
     */
    public static Localizable _CoverageColumn_Caption() {
        return new Localizable(holder, "CoverageColumn.Caption");
    }

    /**
     * Key {@code CoveragePublisher.displayName}: {@code Publish Coverage
     * Report}.
     * 
     * @return
     *     {@code Publish Coverage Report}
     */
    public static String CoveragePublisher_displayName() {
        return holder.format("CoveragePublisher.displayName");
    }

    /**
     * Key {@code CoveragePublisher.displayName}: {@code Publish Coverage
     * Report}.
     * 
     * @return
     *     {@code Publish Coverage Report}
     */
    public static Localizable _CoveragePublisher_displayName() {
        return new Localizable(holder, "CoveragePublisher.displayName");
    }

    /**
     * Key {@code CoverageColumn.ColumnName}: {@code Code Coverage}.
     * 
     * @return
     *     {@code Code Coverage}
     */
    public static String CoverageColumn_ColumnName() {
        return holder.format("CoverageColumn.ColumnName");
    }

    /**
     * Key {@code CoverageColumn.ColumnName}: {@code Code Coverage}.
     * 
     * @return
     *     {@code Code Coverage}
     */
    public static Localizable _CoverageColumn_ColumnName() {
        return new Localizable(holder, "CoverageColumn.ColumnName");
    }

    /**
     * Key {@code CoverageAction.displayName}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static String CoverageAction_displayName() {
        return holder.format("CoverageAction.displayName");
    }

    /**
     * Key {@code CoverageAction.displayName}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static Localizable _CoverageAction_displayName() {
        return new Localizable(holder, "CoverageAction.displayName");
    }

    /**
     * Key {@code CoverageProjectAction.displayName}: {@code Coverage
     * Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static String CoverageProjectAction_displayName() {
        return holder.format("CoverageProjectAction.displayName");
    }

    /**
     * Key {@code CoverageProjectAction.displayName}: {@code Coverage
     * Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static Localizable _CoverageProjectAction_displayName() {
        return new Localizable(holder, "CoverageProjectAction.displayName");
    }

    /**
     * Key {@code CoverageProcessor.healthReportDescriptionTemplate}: {@code
     * Coverage Healthy score is {0}%}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage Healthy score is {0}%}
     */
    public static String CoverageProcessor_healthReportDescriptionTemplate(Object arg0) {
        return holder.format("CoverageProcessor.healthReportDescriptionTemplate", arg0);
    }

    /**
     * Key {@code CoverageProcessor.healthReportDescriptionTemplate}: {@code
     * Coverage Healthy score is {0}%}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage Healthy score is {0}%}
     */
    public static Localizable _CoverageProcessor_healthReportDescriptionTemplate(Object arg0) {
        return new Localizable(holder, "CoverageProcessor.healthReportDescriptionTemplate", arg0);
    }

    /**
     * Key {@code CoverageColumn.CoverageEmpty}: {@code none}.
     * 
     * @return
     *     {@code none}
     */
    public static String CoverageColumn_CoverageEmpty() {
        return holder.format("CoverageColumn.CoverageEmpty");
    }

    /**
     * Key {@code CoverageColumn.CoverageEmpty}: {@code none}.
     * 
     * @return
     *     {@code none}
     */
    public static Localizable _CoverageColumn_CoverageEmpty() {
        return new Localizable(holder, "CoverageColumn.CoverageEmpty");
    }

    /**
     * Key {@code FieldValidator.Error.DefaultEncoding}: {@code Encoding must
     * be a supported encoding of the Java platform, see: <a rel="noopener
     * noreferrer" href="{0}">java.nio.charset.Charset</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encoding must be a supported encoding of the Java platform,
     *     see: <a rel="noopener noreferrer"
     *     href="{0}">java.nio.charset.Charset</a>}
     */
    public static String FieldValidator_Error_DefaultEncoding(Object arg0) {
        return holder.format("FieldValidator.Error.DefaultEncoding", arg0);
    }

    /**
     * Key {@code FieldValidator.Error.DefaultEncoding}: {@code Encoding must
     * be a supported encoding of the Java platform, see: <a rel="noopener
     * noreferrer" href="{0}">java.nio.charset.Charset</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encoding must be a supported encoding of the Java platform,
     *     see: <a rel="noopener noreferrer"
     *     href="{0}">java.nio.charset.Charset</a>}
     */
    public static Localizable _FieldValidator_Error_DefaultEncoding(Object arg0) {
        return new Localizable(holder, "FieldValidator.Error.DefaultEncoding", arg0);
    }

}
