// CHECKSTYLE:OFF

package io.jenkins.plugins.coverage.adapter;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code JacocoReportAdapter.displayName}: {@code Jacoco}.
     * 
     * @return
     *     {@code Jacoco}
     */
    public static String JacocoReportAdapter_displayName() {
        return holder.format("JacocoReportAdapter.displayName");
    }

    /**
     * Key {@code JacocoReportAdapter.displayName}: {@code Jacoco}.
     * 
     * @return
     *     {@code Jacoco}
     */
    public static Localizable _JacocoReportAdapter_displayName() {
        return new Localizable(holder, "JacocoReportAdapter.displayName");
    }

    /**
     * Key {@code CoberturaReportAdapter.displayName}: {@code Cobertura}.
     * 
     * @return
     *     {@code Cobertura}
     */
    public static String CoberturaReportAdapter_displayName() {
        return holder.format("CoberturaReportAdapter.displayName");
    }

    /**
     * Key {@code CoberturaReportAdapter.displayName}: {@code Cobertura}.
     * 
     * @return
     *     {@code Cobertura}
     */
    public static Localizable _CoberturaReportAdapter_displayName() {
        return new Localizable(holder, "CoberturaReportAdapter.displayName");
    }

    /**
     * Key {@code IstanbulCoberturaReportAdapter.displayName}: {@code
     * Istanbul (Cobertura reporter)}.
     * 
     * @return
     *     {@code Istanbul (Cobertura reporter)}
     */
    public static String IstanbulCoberturaReportAdapter_displayName() {
        return holder.format("IstanbulCoberturaReportAdapter.displayName");
    }

    /**
     * Key {@code IstanbulCoberturaReportAdapter.displayName}: {@code
     * Istanbul (Cobertura reporter)}.
     * 
     * @return
     *     {@code Istanbul (Cobertura reporter)}
     */
    public static Localizable _IstanbulCoberturaReportAdapter_displayName() {
        return new Localizable(holder, "IstanbulCoberturaReportAdapter.displayName");
    }

}
