/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.targets;

import io.jenkins.plugins.coverage.targets.CoverageElement;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import io.jenkins.plugins.coverage.targets.CoverageTreeElement;
import io.jenkins.plugins.coverage.targets.Ratio;
import java.io.Serializable;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class CoverageTree
implements Serializable {
    private static final long serialVersionUID = 5112467356061418891L;
    private Map<CoverageElement, Ratio> aggregateResults;
    private Map<String, CoverageResult> children;
    private String name;

    public CoverageTree(String name, Map<CoverageElement, Ratio> aggregateResults, Map<String, CoverageResult> children) {
        this.name = name;
        this.aggregateResults = aggregateResults;
        this.children = children;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public CoverageTreeElement[] getElements() {
        CoverageTreeElement[] cte = new CoverageTreeElement[this.aggregateResults.size()];
        int current = 0;
        for (Map.Entry<CoverageElement, Ratio> e : this.aggregateResults.entrySet()) {
            cte[current] = new CoverageTreeElement(e.getKey(), e.getValue());
            ++current;
        }
        return cte;
    }

    @Exported
    public CoverageTree[] getChildren() {
        CoverageTree[] ct = new CoverageTree[this.children.size()];
        int current = 0;
        for (Map.Entry<String, CoverageResult> e : this.children.entrySet()) {
            ct[current] = new CoverageTree(e.getKey(), e.getValue().getResults(), e.getValue().getChildrenReal());
            ++current;
        }
        return ct;
    }
}

