/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.source;

import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.coverage.source.Messages;
import io.jenkins.plugins.coverage.targets.CoveragePaint;
import java.io.IOException;
import java.util.Map;
import jenkins.model.Jenkins;

public abstract class SourceFileResolver
implements ExtensionPoint,
Describable<SourceFileResolver> {
    private SourceFileResolverLevel level;

    public SourceFileResolver(SourceFileResolverLevel level) {
        this.level = level;
    }

    public abstract void resolveSourceFiles(Run<?, ?> var1, FilePath var2, TaskListener var3, Map<String, CoveragePaint> var4) throws IOException;

    public Descriptor<SourceFileResolver> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public SourceFileResolverLevel getLevel() {
        return this.level;
    }

    public void setLevel(SourceFileResolverLevel level) {
        this.level = level;
    }

    public static enum SourceFileResolverLevel {
        NEVER_STORE(Messages.SourceFileResolver_neverSave()),
        STORE_LAST_BUILD(Messages.SourceFileResolver_saveLast()),
        STORE_ALL_BUILD(Messages.SourceFileResolver_saveAll());

        private String name;

        private SourceFileResolverLevel(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

