/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.targets;

import io.jenkins.plugins.coverage.targets.CoverageElementRegister;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CoverageElement
implements Comparable<CoverageElement>,
Serializable {
    public static final CoverageElement AGGREGATED_REPORT = new CoverageElement("Aggregated Report", Integer.MIN_VALUE);
    public static final CoverageElement REPORT = new CoverageElement("Report", -2147483647);
    public static final CoverageElement LINE = new CoverageElement("Line", 0x7FFFFFFE, true);
    public static final CoverageElement CONDITIONAL = new CoverageElement("Conditional", Integer.MAX_VALUE, true);
    private final String name;
    private final int order;
    private final boolean isBasicBlock;

    public CoverageElement(String name, int order) {
        this(name, order, false);
    }

    public CoverageElement(String name, int order, boolean isBasicBlock) {
        this.name = name;
        this.order = order;
        this.isBasicBlock = isBasicBlock;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBasicBlock() {
        return this.isBasicBlock;
    }

    public boolean is(String name) {
        return this.name.equals(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoverageElement that = (CoverageElement)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public int compareTo(@Nonnull CoverageElement coverageElement) {
        if (this.order == coverageElement.order) {
            return 0;
        }
        return this.order < coverageElement.order ? -1 : 1;
    }

    public static CoverageElement get(String name) {
        return CoverageElementRegister.get(name);
    }
}

