/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.source;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.coverage.BuildUtils;
import io.jenkins.plugins.coverage.exception.CoverageException;
import io.jenkins.plugins.coverage.source.SourceFileResolver;
import io.jenkins.plugins.coverage.targets.CoveragePaint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultSourceFileResolver
extends SourceFileResolver {
    public static final String DEFAULT_SOURCE_CODE_STORE_DIRECTORY = "coverage-sources/";

    @DataBoundConstructor
    public DefaultSourceFileResolver(SourceFileResolver.SourceFileResolverLevel level) {
        super(level);
    }

    @Override
    public void resolveSourceFiles(Run<?, ?> run, FilePath workspace, TaskListener listener, Map<String, CoveragePaint> paints) throws IOException {
        File sourceFileDir;
        Run<?, ?> b;
        Run<?, ?> lastBuild;
        if (this.getLevel() == null || this.getLevel().equals((Object)SourceFileResolver.SourceFileResolverLevel.NEVER_STORE)) {
            return;
        }
        if (this.getLevel().equals((Object)SourceFileResolver.SourceFileResolverLevel.STORE_LAST_BUILD) && (lastBuild = BuildUtils.getPreviousNotFailedCompletedBuild(run)) != null && (b = BuildUtils.getPreviousNotFailedCompletedBuild(lastBuild)) != null && (sourceFileDir = new File(b.getRootDir(), "coverage-sources")).exists() && sourceFileDir.isDirectory()) {
            FileUtils.deleteDirectory((File)sourceFileDir);
        }
        paints.forEach((sourceFilePath, paint) -> {
            FilePath[] possibleFiles;
            try {
                possibleFiles = (FilePath[])workspace.act((FilePath.FileCallable)new MasterToSlaveFileCallable<FilePath[]>(){

                    public FilePath[] invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                        return new FilePath(f).list("**/" + sourceFilePath);
                    }
                });
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                return;
            }
            if (possibleFiles != null && possibleFiles.length > 0) {
                FilePath source = possibleFiles[0];
                FilePath buildDirSourceFile = new FilePath(new File(run.getRootDir(), DEFAULT_SOURCE_CODE_STORE_DIRECTORY + sourceFilePath));
                try {
                    this.paintSourceCode(source, (CoveragePaint)paint, buildDirSourceFile);
                }
                catch (CoverageException e) {
                    listener.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)e));
                }
            } else {
                listener.getLogger().printf("Cannot found source file for %s%n", sourceFilePath);
            }
        });
    }

    private void paintSourceCode(FilePath source, CoveragePaint paint, FilePath canvas) throws CoverageException {
        try (BufferedWriter output = new BufferedWriter(new OutputStreamWriter(canvas.write(), "UTF-8"));
             BufferedReader input = new BufferedReader(new InputStreamReader(source.read(), "UTF-8"));){
            String content;
            int line = 0;
            while ((content = input.readLine()) != null) {
                if (paint.isPainted(++line)) {
                    int coveragePercent;
                    int hits = paint.getHits(line);
                    int branchCoverage = paint.getBranchCoverage(line);
                    int branchTotal = paint.getBranchTotal(line);
                    int n = coveragePercent = hits == 0 ? 0 : (int)((double)branchCoverage * 100.0 / (double)branchTotal);
                    if (paint.getHits(line) > 0) {
                        if (branchTotal == branchCoverage) {
                            output.write("<tr class=\"coverFull\">\n");
                        } else {
                            output.write("<tr class=\"coverPart\" title=\"Line " + line + ": Conditional coverage " + coveragePercent + "% (" + branchCoverage + "/" + branchTotal + ")\">\n");
                        }
                    } else {
                        output.write("<tr class=\"coverNone\">\n");
                    }
                    output.write("<td class=\"line\"><a name='" + line + "'/>" + line + "</td>\n");
                    output.write("<td class=\"hits\">" + hits + "</td>\n");
                } else {
                    output.write("<tr class=\"noCover\">\n");
                    output.write("<td class=\"line\"><a name='" + line + "'/>" + line + "</td>\n");
                    output.write("<td class=\"hits\"/>\n");
                }
                output.write("<td class=\"code\">" + content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "").replace("\r", "").replace(" ", "&nbsp;").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;") + "</td>\n");
                output.write("</tr>\n");
            }
            paint.setTotalLines(line);
        }
        catch (IOException | InterruptedException e) {
            throw new CoverageException(e);
        }
    }

    @Symbol(value={"sourceFiles"})
    @Extension
    public static final class DefaultSourceFileResolverDescriptor<T extends SourceFileResolver>
    extends Descriptor<SourceFileResolver> {
        private static final ListBoxModel LEVELS = new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option(SourceFileResolver.SourceFileResolverLevel.NEVER_STORE.getName(), SourceFileResolver.SourceFileResolverLevel.NEVER_STORE.toString()), new ListBoxModel.Option(SourceFileResolver.SourceFileResolverLevel.STORE_LAST_BUILD.getName(), SourceFileResolver.SourceFileResolverLevel.STORE_LAST_BUILD.toString()), new ListBoxModel.Option(SourceFileResolver.SourceFileResolverLevel.STORE_ALL_BUILD.getName(), SourceFileResolver.SourceFileResolverLevel.STORE_ALL_BUILD.toString())});

        public DefaultSourceFileResolverDescriptor() {
            super(DefaultSourceFileResolver.class);
        }

        public ListBoxModel doFillLevelItems() {
            return LEVELS;
        }
    }
}

