/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.detector;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.coverage.adapter.CoverageAdapter;
import io.jenkins.plugins.coverage.adapter.CoverageAdapterDescriptor;
import io.jenkins.plugins.coverage.adapter.CoverageReportAdapter;
import io.jenkins.plugins.coverage.adapter.CoverageReportAdapterDescriptor;
import io.jenkins.plugins.coverage.detector.Detectable;
import io.jenkins.plugins.coverage.exception.CoverageException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FileUtils;

public abstract class ReportDetector
extends CoverageAdapter {
    protected abstract List<FilePath> findFiles(Run<?, ?> var1, FilePath var2, TaskListener var3) throws CoverageException;

    public Map<CoverageReportAdapter, List<File>> getReports(Run<?, ?> run, FilePath workspace, TaskListener listener, @CheckForNull Predicate<? super FilePath> includeOnly) throws CoverageException {
        try {
            List<Object> detectedFilePaths = this.findFiles(run, workspace, listener);
            if (includeOnly != null) {
                detectedFilePaths = detectedFilePaths.stream().filter(includeOnly).collect(Collectors.toList());
            }
            return this.detectReports(detectedFilePaths, run);
        }
        catch (IOException | InterruptedException | ReflectiveOperationException e) {
            throw new CoverageException(e);
        }
    }

    public Map<CoverageReportAdapter, List<File>> getReports(Run<?, ?> run, FilePath workspace, TaskListener listener) throws CoverageException {
        return this.getReports(run, workspace, listener, null);
    }

    protected Map<CoverageReportAdapter, List<File>> detectReports(List<FilePath> detectedFilePaths, Run<?, ?> run) throws IOException, InterruptedException, ReflectiveOperationException {
        List<CoverageReportAdapterDescriptor> detectableReportDescriptors = this.findDetectableReportDescriptors();
        HashMap<CoverageReportAdapter, List<File>> results = new HashMap<CoverageReportAdapter, List<File>>();
        File rootBuildDir = run.getRootDir();
        for (FilePath fp : detectedFilePaths) {
            File copy = new File(rootBuildDir, fp.getBaseName() + "(D)");
            int i = 0;
            while (copy.exists()) {
                copy = new File(copy.getName() + i++);
            }
            fp.copyTo(new FilePath(copy));
            for (CoverageReportAdapterDescriptor d : detectableReportDescriptors) {
                if (!(d instanceof Detectable)) continue;
                Detectable detectable = (Detectable)((Object)d);
                if (detectable.detect(copy)) {
                    Class clazz = d.clazz;
                    Constructor c = clazz.getConstructor(String.class);
                    if (c == null) continue;
                    CoverageReportAdapter adapter = (CoverageReportAdapter)c.newInstance("");
                    results.putIfAbsent(adapter, new LinkedList());
                    ((List)results.get(adapter)).add(copy);
                    continue;
                }
                FileUtils.deleteQuietly((File)copy);
            }
        }
        return results;
    }

    private List<CoverageReportAdapterDescriptor> findDetectableReportDescriptors() {
        return CoverageAdapterDescriptor.all().stream().filter(d -> d instanceof CoverageReportAdapterDescriptor && d instanceof Detectable).map(d -> (CoverageReportAdapterDescriptor)((Object)d)).collect(Collectors.toList());
    }
}

