/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.adapter;

import io.jenkins.plugins.coverage.adapter.CoverageReportAdapter;
import io.jenkins.plugins.coverage.adapter.util.XMLUtils;
import io.jenkins.plugins.coverage.exception.CoverageException;
import java.io.File;
import java.io.FileNotFoundException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;

public abstract class XMLCoverageReportAdapter
extends CoverageReportAdapter {
    public XMLCoverageReportAdapter(String path) {
        super(path);
    }

    @CheckForNull
    public abstract String getXSL();

    @Nullable
    public abstract String getXSD();

    @Override
    public Document convert(File source) throws CoverageException {
        try {
            StreamSource xsl = this.getRealXSL();
            return XMLUtils.getInstance().convertToDocumentWithXSL(xsl, source);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new CoverageException(e);
        }
    }

    protected StreamSource getRealXSL() throws FileNotFoundException {
        String xsl = this.getXSL();
        if (StringUtils.isEmpty((String)xsl)) {
            throw new FileNotFoundException("Cannot found xsl file, xsl path must be no-empty");
        }
        return new StreamSource(this.getXSLResourceClass().getResourceAsStream(xsl));
    }

    private Class getXSLResourceClass() {
        return this.getClass();
    }
}

