/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import io.jenkins.plugins.coverage.CoverageProcessor;
import io.jenkins.plugins.coverage.Messages;
import io.jenkins.plugins.coverage.adapter.CoverageAdapter;
import io.jenkins.plugins.coverage.adapter.CoverageAdapterDescriptor;
import io.jenkins.plugins.coverage.adapter.CoverageReportAdapter;
import io.jenkins.plugins.coverage.detector.ReportDetector;
import io.jenkins.plugins.coverage.exception.CoverageException;
import io.jenkins.plugins.coverage.source.DefaultSourceFileResolver;
import io.jenkins.plugins.coverage.source.SourceFileResolver;
import io.jenkins.plugins.coverage.threshold.Threshold;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class CoveragePublisher
extends Recorder
implements SimpleBuildStep {
    private List<CoverageAdapter> adapters = new LinkedList<CoverageAdapter>();
    private List<Threshold> globalThresholds = new LinkedList<Threshold>();
    private boolean failUnhealthy;
    private boolean failUnstable;
    private boolean failNoReports;
    private DefaultSourceFileResolver sourceFileResolver;
    private String tag;

    @DataBoundConstructor
    public CoveragePublisher() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Publishing Coverage report....");
        CoverageProcessor processor = new CoverageProcessor(run, workspace, listener);
        LinkedList<CoverageReportAdapter> reportAdapters = new LinkedList<CoverageReportAdapter>();
        LinkedList<ReportDetector> reportDetectors = new LinkedList<ReportDetector>();
        for (CoverageAdapter adapter : this.getAdapters()) {
            if (adapter instanceof CoverageReportAdapter) {
                reportAdapters.add((CoverageReportAdapter)adapter);
                continue;
            }
            if (!(adapter instanceof ReportDetector)) continue;
            reportDetectors.add((ReportDetector)adapter);
        }
        if (this.sourceFileResolver != null) {
            processor.setSourceFileResolver(this.sourceFileResolver);
        }
        processor.setGlobalTag(this.tag);
        processor.setFailUnhealthy(this.failUnhealthy);
        processor.setFailUnstable(this.failUnstable);
        processor.setFailNoReports(this.failNoReports);
        try {
            processor.performCoverageReport(reportAdapters, reportDetectors, this.globalThresholds);
        }
        catch (CoverageException e) {
            listener.getLogger().println(ExceptionUtils.getFullStackTrace((Throwable)e));
            run.setResult(Result.FAILURE);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public List<CoverageAdapter> getAdapters() {
        return this.adapters;
    }

    @DataBoundSetter
    public void setAdapters(List<CoverageAdapter> adapters) {
        this.adapters = adapters;
    }

    public List<Threshold> getGlobalThresholds() {
        return this.globalThresholds;
    }

    @DataBoundSetter
    public void setGlobalThresholds(List<Threshold> globalThresholds) {
        this.globalThresholds = globalThresholds;
    }

    public boolean isFailUnhealthy() {
        return this.failUnhealthy;
    }

    @DataBoundSetter
    public void setFailUnhealthy(boolean failUnhealthy) {
        this.failUnhealthy = failUnhealthy;
    }

    public boolean isFailUnstable() {
        return this.failUnstable;
    }

    @DataBoundSetter
    public void setFailUnstable(boolean failUnstable) {
        this.failUnstable = failUnstable;
    }

    public boolean isFailNoReports() {
        return this.failNoReports;
    }

    @DataBoundSetter
    public void setFailNoReports(boolean failNoReports) {
        this.failNoReports = failNoReports;
    }

    public DefaultSourceFileResolver getSourceFileResolver() {
        return this.sourceFileResolver;
    }

    @DataBoundSetter
    public void setSourceFileResolver(DefaultSourceFileResolver sourceFileResolver) {
        this.sourceFileResolver = sourceFileResolver;
    }

    public String getTag() {
        return this.tag;
    }

    @DataBoundSetter
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Symbol(value={"publishCoverage"})
    @Extension
    public static final class CoveragePublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        public CoveragePublisherDescriptor() {
            super(CoveragePublisher.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            super.configure(req, json);
            this.save();
            return true;
        }

        public DescriptorExtensionList<CoverageAdapter, CoverageAdapterDescriptor<?>> getListCoverageReportAdapterDescriptors() {
            return CoverageAdapterDescriptor.all();
        }

        public Descriptor<SourceFileResolver> getSourceFileResolverDescriptor() {
            return new DefaultSourceFileResolver.DefaultSourceFileResolverDescriptor();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.CoveragePublisher_displayName();
        }

        public Publisher newInstance(@CheckForNull StaplerRequest req, @Nonnull JSONObject formData) throws Descriptor.FormException {
            return (Publisher)super.newInstance(req, formData);
        }
    }
}

