/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage;

import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Run;
import io.jenkins.plugins.coverage.CoverageProcessor;
import io.jenkins.plugins.coverage.CoverageProjectAction;
import io.jenkins.plugins.coverage.Messages;
import io.jenkins.plugins.coverage.targets.CoverageResult;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerProxy;

public class CoverageAction
implements StaplerProxy,
SimpleBuildStep.LastBuildAction,
RunAction2,
HealthReportingAction {
    private transient Run<?, ?> owner;
    private transient WeakReference<CoverageResult> report;
    private HealthReport healthReport;

    public CoverageAction(CoverageResult result) {
        this.report = new WeakReference<CoverageResult>(result);
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new CoverageProjectAction(this.owner));
    }

    public HealthReport getBuildHealth() {
        return this.getHealthReport();
    }

    public CoverageResult getResult() {
        CoverageResult coverageResult;
        if (this.report != null && (coverageResult = (CoverageResult)this.report.get()) != null) {
            return coverageResult;
        }
        coverageResult = null;
        try {
            coverageResult = CoverageProcessor.recoverCoverageResult(this.owner);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (coverageResult != null) {
            coverageResult.setOwner(this.owner);
            this.report = new WeakReference<CoverageResult>(coverageResult);
        }
        return coverageResult;
    }

    public Object getTarget() {
        return this.getResult();
    }

    public HealthReport getHealthReport() {
        return this.healthReport;
    }

    public void setHealthReport(HealthReport healthReport) {
        this.healthReport = healthReport;
    }

    private synchronized void setOwner(Run<?, ?> owner) {
        CoverageResult coverageResult;
        this.owner = owner;
        if (this.report != null && (coverageResult = (CoverageResult)this.report.get()) != null) {
            coverageResult.setOwner(owner);
        }
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return Messages.CoverageAction_displayName();
    }

    @CheckForNull
    public String getUrlName() {
        return "coverage";
    }

    public void onAttached(Run<?, ?> r) {
        this.setOwner(r);
    }

    public void onLoad(Run<?, ?> r) {
        this.setOwner(r);
    }
}

