/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.status;

import hudson.model.Run;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.TruncatedString;
import io.jenkins.plugins.checks.status.AbstractRunAnalyzer;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;

class FreeStyleBuildAnalyzer
extends AbstractRunAnalyzer {
    private static final int MAX_LOG_LINES = 1000;

    FreeStyleBuildAnalyzer(Run<?, ?> run, boolean suppressLogs) {
        super(run, suppressLogs);
    }

    @Override
    public ChecksOutput extractOutput() {
        String title = this.extractOutputTitle(Optional.empty());
        ChecksOutput.ChecksOutputBuilder output = new ChecksOutput.ChecksOutputBuilder().withTitle(title);
        if (this.isSuppressLogs()) {
            return output.build();
        }
        TruncatedString.Builder summaryBuilder = new TruncatedString.Builder().withTruncationText("Build log truncated.\n\n");
        try {
            List allLines = this.getRun().getLog(1001);
            boolean truncatedLines = allLines.size() > 1000;
            int maxMessageSize = 65535 - "<details><summary>Build Log</summary>%n%n```%n%s%n```%n%n</details>".length() - 32;
            if (truncatedLines) {
                allLines = allLines.subList(1, 1001);
            }
            String log = String.join((CharSequence)"\n", allLines);
            log = log.replaceAll("\u001b\\[[;\\d]*m", "");
            TruncatedString.Builder logBuilder = new TruncatedString.Builder().setChunkOnNewlines().setTruncateStart().withTruncationText("Build log truncated.\n\n").addText(log);
            if (truncatedLines) {
                logBuilder.setForceTruncationText();
            }
            if (StringUtils.isNotBlank((CharSequence)(log = logBuilder.build().build(maxMessageSize)))) {
                summaryBuilder.addText(String.format("<details><summary>Build Log</summary>%n%n```%n%s%n```%n%n</details>", log));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Failed to extract logs for step '%s'", this.getRun().getDisplayName()).replaceAll("[\r\n]", ""), e);
            return output.build();
        }
        return output.withSummary(summaryBuilder.build()).build();
    }
}

