/*
 * Decompiled with CFR 0.152.
 */
package com.buildstash;

import com.buildstash.BuildstashUploadRequest;
import com.buildstash.BuildstashUploadResponse;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;

public class BuildstashUploadHelper {
    public static String expand(EnvVars env, String value) {
        if (value == null || env == null) {
            return value;
        }
        return env.expand(value);
    }

    public static void validateParameters(String apiKey, String primaryFilePath, String versionComponent1Major, String versionComponent2Minor, String versionComponent3Patch, String platform, String stream) {
        if (apiKey == null || apiKey.isBlank()) {
            throw new IllegalArgumentException("API key is required");
        }
        if (primaryFilePath == null || primaryFilePath.isBlank()) {
            throw new IllegalArgumentException("Primary file path is required");
        }
        if (versionComponent1Major == null || versionComponent1Major.isBlank()) {
            throw new IllegalArgumentException("Major version component is required");
        }
        if (versionComponent2Minor == null || versionComponent2Minor.isBlank()) {
            throw new IllegalArgumentException("Minor version component is required");
        }
        if (versionComponent3Patch == null || versionComponent3Patch.isBlank()) {
            throw new IllegalArgumentException("Patch version component is required");
        }
        if (platform == null || platform.isBlank()) {
            throw new IllegalArgumentException("Platform is required");
        }
        if (stream == null || stream.isBlank()) {
            throw new IllegalArgumentException("Stream is required");
        }
    }

    public static BuildstashUploadRequest createUploadRequest(FilePath workspace, Run<?, ?> build, String structure, String primaryFilePath, String expansionFilePath, String versionComponent1Major, String versionComponent2Minor, String versionComponent3Patch, String versionComponentExtra, String versionComponentMeta, String customBuildNumber, String labels, String architectures, String platform, String stream, String notes, String vcHostType, String vcHost, String vcRepoName, String vcRepoUrl, String vcBranch, String vcCommitSha, String vcCommitUrl) throws IOException, InterruptedException {
        BuildstashUploadRequest request = new BuildstashUploadRequest();
        request.setStructure(structure);
        request.setPrimaryFilePath(primaryFilePath);
        request.setExpansionFilePath(expansionFilePath);
        request.setVersionComponent1Major(versionComponent1Major);
        request.setVersionComponent2Minor(versionComponent2Minor);
        request.setVersionComponent3Patch(versionComponent3Patch);
        request.setVersionComponentExtra(versionComponentExtra);
        request.setVersionComponentMeta(versionComponentMeta);
        request.setCustomBuildNumber(customBuildNumber);
        request.setPlatform(platform);
        request.setStream(stream);
        request.setNotes(notes);
        if (labels != null && !labels.isBlank()) {
            List<String> labelsList = Arrays.stream(labels.split("[,\\r\\n]+")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            request.setLabels(labelsList);
        }
        if (architectures != null && !architectures.isBlank()) {
            List<String> architecturesList = Arrays.stream(architectures.split("[,\\r\\n]+")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            request.setArchitectures(architecturesList);
        }
        request.setCiPipeline(build.getParent().getDisplayName());
        request.setCiRunId(String.valueOf(build.getNumber()));
        request.setCiRunUrl(BuildstashUploadHelper.getBuildUrl(build));
        request.setCiPipelineUrl(BuildstashUploadHelper.getProjectUrl(build));
        request.setCiBuildDuration(BuildstashUploadHelper.formatBuildDuration(BuildstashUploadHelper.getBuildDuration(build)));
        request.setSource("jenkins");
        if (vcHostType != null && !vcHostType.isBlank()) {
            request.setVcHostType(vcHostType);
        }
        if (vcHost != null && !vcHost.isBlank()) {
            request.setVcHost(vcHost);
        }
        if (vcRepoName != null && !vcRepoName.isBlank()) {
            request.setVcRepoName(vcRepoName);
        }
        if (vcRepoUrl != null && !vcRepoUrl.isBlank()) {
            request.setVcRepoUrl(vcRepoUrl);
        }
        if (vcBranch != null && !vcBranch.isBlank()) {
            request.setVcBranch(vcBranch);
        }
        if (vcCommitSha != null && !vcCommitSha.isBlank()) {
            request.setVcCommitSha(vcCommitSha);
        }
        if (vcCommitUrl != null && !vcCommitUrl.isBlank()) {
            request.setVcCommitUrl(vcCommitUrl);
        }
        request.setWorkspace(workspace);
        return request;
    }

    public static String getBuildUrl(Run<?, ?> build) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            return jenkins.getRootUrl() + build.getUrl();
        }
        return build.getUrl();
    }

    public static String getProjectUrl(Run<?, ?> build) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            return jenkins.getRootUrl() + build.getParent().getUrl();
        }
        return build.getParent().getUrl();
    }

    public static long getBuildDuration(Run<?, ?> build) {
        long duration = build.getDuration();
        if (duration == 0L) {
            long startTime = build.getStartTimeInMillis();
            long currentTime = System.currentTimeMillis();
            duration = currentTime - startTime;
        }
        return duration;
    }

    public static String formatBuildDuration(long durationMs) {
        long totalSeconds = durationMs / 1000L;
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public static void logResults(TaskListener listener, BuildstashUploadResponse response) {
        listener.getLogger().println("Buildstash upload completed successfully!");
        listener.getLogger().println("Build ID: " + response.getBuildId());
        listener.getLogger().println("Build Info URL: " + response.getBuildInfoUrl());
        listener.getLogger().println("Download URL: " + response.getDownloadUrl());
        listener.getLogger().println("Pending Processing: " + response.isPendingProcessing());
    }
}

