/*
 * Decompiled with CFR 0.152.
 */
package com.buildstash;

import com.buildstash.BuildstashBuildAction;
import com.buildstash.BuildstashUploadHelper;
import com.buildstash.BuildstashUploadRequest;
import com.buildstash.BuildstashUploadResponse;
import com.buildstash.BuildstashUploadService;
import com.buildstash.VersionControlDetector;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BuildstashBuilder
extends Recorder
implements SimpleBuildStep {
    private Secret apiKey;
    private String structure = "file";
    private String primaryFilePath;
    private String expansionFilePath;
    private String versionComponent1Major;
    private String versionComponent2Minor;
    private String versionComponent3Patch;
    private String versionComponentExtra;
    private String versionComponentMeta;
    private String customBuildNumber;
    private String labels;
    private String architectures;
    private String vcHostType = "git";
    private String vcHost = "github";
    private String vcRepoName;
    private String vcRepoUrl;
    private String vcBranch;
    private String vcCommitSha;
    private String vcCommitUrl;
    private String platform;
    private String stream;
    private String notes;

    @DataBoundConstructor
    public BuildstashBuilder() {
    }

    public void perform(Run<?, ?> build, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        try {
            String apiKeyPlain = this.apiKey != null ? Secret.toString((Secret)this.apiKey) : null;
            String expandedApiKey = BuildstashUploadHelper.expand(env, apiKeyPlain);
            String expandedStructure = BuildstashUploadHelper.expand(env, this.structure);
            if (expandedStructure == null || expandedStructure.isBlank()) {
                expandedStructure = "file";
            }
            String expandedPrimaryFilePath = BuildstashUploadHelper.expand(env, this.primaryFilePath);
            String expandedExpansionFilePath = BuildstashUploadHelper.expand(env, this.expansionFilePath);
            String expandedVersionComponent1Major = BuildstashUploadHelper.expand(env, this.versionComponent1Major);
            String expandedVersionComponent2Minor = BuildstashUploadHelper.expand(env, this.versionComponent2Minor);
            String expandedVersionComponent3Patch = BuildstashUploadHelper.expand(env, this.versionComponent3Patch);
            String expandedVersionComponentExtra = BuildstashUploadHelper.expand(env, this.versionComponentExtra);
            String expandedVersionComponentMeta = BuildstashUploadHelper.expand(env, this.versionComponentMeta);
            String expandedCustomBuildNumber = BuildstashUploadHelper.expand(env, this.customBuildNumber);
            String expandedLabels = BuildstashUploadHelper.expand(env, this.labels);
            String expandedArchitectures = BuildstashUploadHelper.expand(env, this.architectures);
            String expandedPlatform = BuildstashUploadHelper.expand(env, this.platform);
            String expandedStream = BuildstashUploadHelper.expand(env, this.stream);
            String expandedNotes = BuildstashUploadHelper.expand(env, this.notes);
            String expandedVcHostType = BuildstashUploadHelper.expand(env, this.vcHostType);
            String expandedVcHost = BuildstashUploadHelper.expand(env, this.vcHost);
            String expandedVcRepoName = BuildstashUploadHelper.expand(env, this.vcRepoName);
            String expandedVcRepoUrl = BuildstashUploadHelper.expand(env, this.vcRepoUrl);
            String expandedVcBranch = BuildstashUploadHelper.expand(env, this.vcBranch);
            String expandedVcCommitSha = BuildstashUploadHelper.expand(env, this.vcCommitSha);
            String expandedVcCommitUrl = BuildstashUploadHelper.expand(env, this.vcCommitUrl);
            BuildstashUploadHelper.validateParameters(expandedApiKey, expandedPrimaryFilePath, expandedVersionComponent1Major, expandedVersionComponent2Minor, expandedVersionComponent3Patch, expandedPlatform, expandedStream);
            BuildstashUploadService uploadService = new BuildstashUploadService(expandedApiKey, listener);
            BuildstashUploadRequest request = BuildstashUploadHelper.createUploadRequest(workspace, build, expandedStructure, expandedPrimaryFilePath, expandedExpansionFilePath, expandedVersionComponent1Major, expandedVersionComponent2Minor, expandedVersionComponent3Patch, expandedVersionComponentExtra, expandedVersionComponentMeta, expandedCustomBuildNumber, expandedLabels, expandedArchitectures, expandedPlatform, expandedStream, expandedNotes, expandedVcHostType, expandedVcHost, expandedVcRepoName, expandedVcRepoUrl, expandedVcBranch, expandedVcCommitSha, expandedVcCommitUrl);
            VersionControlDetector.populateVersionControlInfo(build, request, listener);
            BuildstashUploadResponse response = uploadService.upload(request);
            BuildstashUploadHelper.logResults(listener, response);
            BuildstashBuildAction existingAction = (BuildstashBuildAction)build.getAction(BuildstashBuildAction.class);
            if (existingAction != null) {
                existingAction.addResponse(response);
            } else {
                build.addAction((Action)new BuildstashBuildAction(response));
            }
        }
        catch (Exception e) {
            listener.error("Buildstash upload failed: " + e.getMessage());
            e.printStackTrace(listener.getLogger());
            throw new RuntimeException("Buildstash upload failed", e);
        }
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    @DataBoundSetter
    public void setApiKey(String apiKey) {
        this.apiKey = Secret.fromString((String)apiKey);
    }

    public void setApiKey(Secret apiKey) {
        this.apiKey = apiKey;
    }

    public String getStructure() {
        return this.structure;
    }

    @DataBoundSetter
    public void setStructure(String structure) {
        this.structure = structure;
    }

    public String getPrimaryFilePath() {
        return this.primaryFilePath;
    }

    @DataBoundSetter
    public void setPrimaryFilePath(String primaryFilePath) {
        this.primaryFilePath = primaryFilePath;
    }

    public String getExpansionFilePath() {
        return this.expansionFilePath;
    }

    @DataBoundSetter
    public void setExpansionFilePath(String expansionFilePath) {
        this.expansionFilePath = expansionFilePath;
    }

    public String getVersionComponent1Major() {
        return this.versionComponent1Major;
    }

    @DataBoundSetter
    public void setVersionComponent1Major(String versionComponent1Major) {
        this.versionComponent1Major = versionComponent1Major;
    }

    public String getVersionComponent2Minor() {
        return this.versionComponent2Minor;
    }

    @DataBoundSetter
    public void setVersionComponent2Minor(String versionComponent2Minor) {
        this.versionComponent2Minor = versionComponent2Minor;
    }

    public String getVersionComponent3Patch() {
        return this.versionComponent3Patch;
    }

    @DataBoundSetter
    public void setVersionComponent3Patch(String versionComponent3Patch) {
        this.versionComponent3Patch = versionComponent3Patch;
    }

    public String getVersionComponentExtra() {
        return this.versionComponentExtra;
    }

    @DataBoundSetter
    public void setVersionComponentExtra(String versionComponentExtra) {
        this.versionComponentExtra = versionComponentExtra;
    }

    public String getVersionComponentMeta() {
        return this.versionComponentMeta;
    }

    @DataBoundSetter
    public void setVersionComponentMeta(String versionComponentMeta) {
        this.versionComponentMeta = versionComponentMeta;
    }

    public String getCustomBuildNumber() {
        return this.customBuildNumber;
    }

    @DataBoundSetter
    public void setCustomBuildNumber(String customBuildNumber) {
        this.customBuildNumber = customBuildNumber;
    }

    public String getLabels() {
        return this.labels;
    }

    @DataBoundSetter
    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getArchitectures() {
        return this.architectures;
    }

    @DataBoundSetter
    public void setArchitectures(String architectures) {
        this.architectures = architectures;
    }

    public String getVcHostType() {
        return this.vcHostType;
    }

    @DataBoundSetter
    public void setVcHostType(String vcHostType) {
        this.vcHostType = vcHostType;
    }

    public String getVcHost() {
        return this.vcHost;
    }

    @DataBoundSetter
    public void setVcHost(String vcHost) {
        this.vcHost = vcHost;
    }

    public String getVcRepoName() {
        return this.vcRepoName;
    }

    @DataBoundSetter
    public void setVcRepoName(String vcRepoName) {
        this.vcRepoName = vcRepoName;
    }

    public String getVcRepoUrl() {
        return this.vcRepoUrl;
    }

    @DataBoundSetter
    public void setVcRepoUrl(String vcRepoUrl) {
        this.vcRepoUrl = vcRepoUrl;
    }

    public String getVcBranch() {
        return this.vcBranch;
    }

    @DataBoundSetter
    public void setVcBranch(String vcBranch) {
        this.vcBranch = vcBranch;
    }

    public String getVcCommitSha() {
        return this.vcCommitSha;
    }

    @DataBoundSetter
    public void setVcCommitSha(String vcCommitSha) {
        this.vcCommitSha = vcCommitSha;
    }

    public String getVcCommitUrl() {
        return this.vcCommitUrl;
    }

    @DataBoundSetter
    public void setVcCommitUrl(String vcCommitUrl) {
        this.vcCommitUrl = vcCommitUrl;
    }

    public String getPlatform() {
        return this.platform;
    }

    @DataBoundSetter
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getStream() {
        return this.stream;
    }

    @DataBoundSetter
    public void setStream(String stream) {
        this.stream = stream;
    }

    public String getNotes() {
        return this.notes;
    }

    @DataBoundSetter
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Upload to Buildstash";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillStructureItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("File", "file");
            items.add("File + Expansion", "file+expansion");
            return items;
        }
    }
}

