/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.buildkite.step;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import io.jenkins.plugins.buildkite.api_client.BuildkiteApiClient;
import io.jenkins.plugins.buildkite.api_client.BuildkiteApiException;
import io.jenkins.plugins.buildkite.api_client.BuildkiteBuild;
import io.jenkins.plugins.buildkite.api_client.CreateBuildRequest;
import io.jenkins.plugins.buildkite.step.BuildkiteStep;
import java.io.PrintStream;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.springframework.security.core.Authentication;

public class BuildkiteStepExecution
extends SynchronousNonBlockingStepExecution<Void> {
    private static final long serialVersionUID = 1L;
    private final transient BuildkiteStep step;
    private boolean buildPaused = false;

    public BuildkiteStepExecution(@NonNull BuildkiteStep step, @NonNull StepContext context) {
        super(context);
        this.step = step;
    }

    protected Void run() throws Exception {
        BuildkiteBuild build;
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        PrintStream console = listener.getLogger();
        this.printCreatingBuild(console);
        StringCredentials credentials = this.getCredentials(console);
        if (credentials == null) {
            return null;
        }
        BuildkiteApiClient client = new BuildkiteApiClient(credentials.getSecret());
        try {
            build = client.createBuild(this.step.getOrganization(), this.step.getPipeline(), this.generateCreateBuildRequest());
        }
        catch (BuildkiteApiException e) {
            String errorMessage = String.format("Failed to create Buildkite build: %s", e.getMessage());
            console.println(errorMessage);
            this.getContext().onFailure((Throwable)new FlowInterruptedException(Result.FAILURE, new CauseOfInterruption[0]));
            return null;
        }
        this.printBuildCreated(build, console);
        if (this.step.isAsync()) {
            this.getContext().onSuccess((Object)build);
            return null;
        }
        return this.waitForBuildCompletion(client, build, console);
    }

    private StringCredentials getCredentials(PrintStream console) {
        StringCredentials credentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StringCredentials.class, null, (Authentication)ACL.SYSTEM2), (CredentialsMatcher)CredentialsMatchers.withId((String)this.step.getCredentialsId()));
        if (credentials == null) {
            String errorMessage = String.format("Could not find Credentials with id: %s", this.step.getCredentialsId());
            console.println(errorMessage);
            this.getContext().onFailure((Throwable)new FlowInterruptedException(Result.FAILURE, new CauseOfInterruption[0]));
        }
        return credentials;
    }

    private CreateBuildRequest generateCreateBuildRequest() {
        return CreateBuildRequest.builder().branch(this.step.getBranch()).commit(this.step.getCommit()).message(this.step.getMessage()).build();
    }

    private Void waitForBuildCompletion(BuildkiteApiClient client, BuildkiteBuild build, PrintStream console) throws Exception {
        console.println("Waiting for build to finish");
        this.sleepMillis(2000L);
        BuildkiteBuild pollingBuild = null;
        while (pollingBuild == null || !pollingBuild.buildFinished()) {
            try {
                pollingBuild = client.getBuild(this.step.getOrganization(), this.step.getPipeline(), build.getNumber());
            }
            catch (BuildkiteApiException e) {
                String errorMessage = String.format("Failed to get Buildkite build status: %s", e.getMessage());
                console.println(errorMessage);
                this.getContext().onFailure((Throwable)new FlowInterruptedException(Result.FAILURE, new CauseOfInterruption[0]));
                return null;
            }
            console.println(String.format("  %s", pollingBuild.getState()));
            try {
                this.sleepMillis(7000L);
            }
            catch (InterruptedException e) {
                console.println("Wait canceled");
                this.getContext().onFailure((Throwable)new FlowInterruptedException(Result.FAILURE, new CauseOfInterruption[0]));
                return null;
            }
            this.buildPaused = this.isBuildPaused();
            if (!this.buildPaused) continue;
        }
        if (this.buildPaused) {
            console.println("Wait canceled - Jenkins build was paused.");
            this.getContext().onFailure((Throwable)new FlowInterruptedException(Result.FAILURE, new CauseOfInterruption[0]));
            return null;
        }
        this.printBuildFinished(pollingBuild, console);
        if (pollingBuild.buildPassed()) {
            this.getContext().onSuccess((Object)build);
        } else {
            this.getContext().onFailure((Throwable)new FlowInterruptedException(Result.FAILURE, new CauseOfInterruption[0]));
        }
        return null;
    }

    protected void sleepMillis(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    private void printCreatingBuild(PrintStream console) {
        String message = String.format("Creating build for %s/%s on %s (%s)", this.step.getOrganization(), this.step.getPipeline(), this.step.getBranch(), this.step.getCommit());
        console.println(message);
    }

    private void printBuildCreated(BuildkiteBuild build, PrintStream console) {
        console.println(String.format("%s/%s#%s created: %s", this.step.getOrganization(), this.step.getPipeline(), build.getNumber(), build.getWebUrl()));
    }

    private void printBuildFinished(BuildkiteBuild build, PrintStream console) {
        String message = String.format("%s/%s#%s finished with state: %s", this.step.getOrganization(), this.step.getPipeline(), build.getNumber(), build.getState());
        console.println(message);
    }

    private boolean isBuildPaused() {
        Run run = null;
        try {
            run = (Run)this.getContext().get(Run.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (run instanceof WorkflowRun) {
            WorkflowRun workflowRun = (WorkflowRun)run;
            CpsFlowExecution execution = (CpsFlowExecution)workflowRun.getExecution();
            return execution != null && execution.isPaused();
        }
        return false;
    }
}

