/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.buildkite.step;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.buildkite.step.BuildkiteStepExecution;
import java.util.Set;
import java.util.logging.Logger;
import lombok.Generated;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BuildkiteStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(BuildkiteStep.class.getName());
    private final String organization;
    private final String pipeline;
    private final String credentialsId;
    private String branch;
    private String commit;
    private String message;
    private boolean async;

    @DataBoundConstructor
    public BuildkiteStep(String organization, String pipeline, String credentialsId) {
        this.organization = organization;
        this.pipeline = pipeline;
        this.credentialsId = credentialsId;
        this.branch = "main";
        this.commit = "HEAD";
        this.async = false;
    }

    public StepExecution start(StepContext context) {
        if (this.message == null) {
            String fullDisplayName;
            try {
                fullDisplayName = ((Run)context.get(Run.class)).getFullDisplayName();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.message = String.format("Triggered by Jenkins build \"%s\"", fullDisplayName);
        }
        return new BuildkiteStepExecution(this, context);
    }

    @DataBoundSetter
    public void setBranch(String branch) {
        if (branch == null || branch.trim().isEmpty()) {
            return;
        }
        this.branch = branch;
    }

    @DataBoundSetter
    public void setCommit(String commit) {
        if (commit == null || commit.trim().isEmpty()) {
            return;
        }
        this.commit = commit;
    }

    @DataBoundSetter
    public void setMessage(String message) {
        if (message == null || message.trim().isEmpty()) {
            return;
        }
        this.message = message;
    }

    @DataBoundSetter
    public void setAsync(boolean async) {
        this.async = async;
    }

    @Generated
    public String getOrganization() {
        return this.organization;
    }

    @Generated
    public String getPipeline() {
        return this.pipeline;
    }

    @Generated
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Generated
    public String getBranch() {
        return this.branch;
    }

    @Generated
    public String getCommit() {
        return this.commit;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public boolean isAsync() {
        return this.async;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(TaskListener.class, Run.class);
        }

        public String getFunctionName() {
            return "buildkite";
        }

        public String getDisplayName() {
            return "Trigger a Buildkite Build";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            item.checkPermission(Item.BUILD);
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM2, item, StringCredentials.class);
        }
    }
}

