/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.buildkite.api_client;

import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.util.Secret;
import jenkins.model.Jenkins;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Timeout;

class HttpClient {
    HttpClient() {
    }

    public static HttpClientBuilder getCloseableHttpClientBuilder() {
        ProxyConfiguration proxy;
        int timeoutInSeconds = 60;
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)timeoutInSeconds)).setSocketTimeout(Timeout.ofSeconds((long)timeoutInSeconds)).build();
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfig).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)timeoutInSeconds)).build();
        HttpClientBuilder clientBuilder = HttpClients.custom().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        Jenkins jenkinsInstance = Jenkins.getInstanceOrNull();
        ProxyConfiguration proxyConfiguration = proxy = jenkinsInstance != null ? jenkinsInstance.proxy : null;
        if (proxy != null && Util.fixEmpty((String)proxy.name) != null) {
            HttpHost proxyHost = new HttpHost(proxy.name, proxy.port);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
            clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            String proxyUser = Util.fixEmpty((String)proxy.getUserName());
            char[] proxyPassword = Secret.toString((Secret)proxy.getSecretPassword()).toCharArray();
            if (proxyUser != null) {
                AuthScope authScope = new AuthScope(proxy.name, proxy.port);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                clientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)new DefaultAuthenticationStrategy());
            }
        }
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        return clientBuilder;
    }

    public static CloseableHttpClient getCloseableHttpClient() {
        return HttpClient.getCloseableHttpClientBuilder().build();
    }
}

