/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.buildkite.api_client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.util.Secret;
import io.jenkins.plugins.buildkite.api_client.BuildkiteApiException;
import io.jenkins.plugins.buildkite.api_client.BuildkiteBuild;
import io.jenkins.plugins.buildkite.api_client.CreateBuildRequest;
import io.jenkins.plugins.buildkite.api_client.HttpClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class BuildkiteApiClient {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String BUILDKITE_API_BASE = "https://api.buildkite.com/v2";
    private Secret apiToken;
    private CloseableHttpClient httpClient;

    public BuildkiteApiClient(Secret apiToken) {
        this.apiToken = apiToken;
        this.httpClient = HttpClient.getCloseableHttpClient();
    }

    public BuildkiteBuild createBuild(String organization, String pipeline, CreateBuildRequest createBuildRequest) throws BuildkiteApiException {
        BuildkiteBuild buildkiteBuild;
        block10: {
            String url = String.format("%s/organizations/%s/pipelines/%s/builds", BUILDKITE_API_BASE, organization, pipeline);
            HttpPost request = new HttpPost(url);
            request.setHeader("Authorization", (Object)String.format("Bearer %s", this.apiToken.getPlainText()));
            request.setHeader("Content-Type", (Object)"application/json");
            String requestJson = null;
            try {
                requestJson = MAPPER.writeValueAsString((Object)createBuildRequest);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            request.setEntity((HttpEntity)new StringEntity(requestJson, StandardCharsets.UTF_8));
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);
            try {
                buildkiteBuild = this.handleResponse(response);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return buildkiteBuild;
    }

    public BuildkiteBuild getBuild(String organization, String pipeline, int buildNumber) throws BuildkiteApiException {
        BuildkiteBuild buildkiteBuild;
        block8: {
            String url = String.format("%s/organizations/%s/pipelines/%s/builds/%s", BUILDKITE_API_BASE, organization, pipeline, buildNumber);
            HttpGet request = new HttpGet(url);
            request.setHeader("Authorization", (Object)String.format("Bearer %s", this.apiToken.getPlainText()));
            request.setHeader("Content-Type", (Object)"application/json");
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);
            try {
                buildkiteBuild = this.handleResponse(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return buildkiteBuild;
    }

    private BuildkiteBuild handleResponse(CloseableHttpResponse response) throws BuildkiteApiException {
        int statusCode = response.getCode();
        if (statusCode < 200 || statusCode >= 400) {
            try {
                String responseBody = response.getEntity() != null ? new String(response.getEntity().getContent().readAllBytes(), StandardCharsets.UTF_8) : "";
                throw new BuildkiteApiException(statusCode, responseBody);
            }
            catch (IOException e) {
                throw new BuildkiteApiException(statusCode, "", e);
            }
        }
        return this.responseToBuildkiteBuild(response);
    }

    private BuildkiteBuild responseToBuildkiteBuild(CloseableHttpResponse response) {
        BuildkiteBuild.BuildkiteBuildBuilder builder = BuildkiteBuild.builder();
        try {
            JsonNode json = MAPPER.readTree(response.getEntity().getContent());
            builder.id(json.get("id").asText()).number(json.get("number").asInt()).state(json.get("state").asText()).webUrl(json.get("web_url").asText()).commit(json.get("commit").asText()).branch(json.get("branch").asText()).url(json.get("url").asText());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    }
}

