/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.mwdle.bitwarden.BitwardenCredentialsProvider;
import com.mwdle.bitwarden.Messages;
import hudson.model.ItemGroup;
import hudson.security.Permission;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.Authentication;

public class BitwardenCredentialsStore
extends CredentialsStore {
    private final transient BitwardenCredentialsProvider provider;
    private final transient BitwardenCredentialStoreAction action;

    public BitwardenCredentialsStore(BitwardenCredentialsProvider provider) {
        super(BitwardenCredentialsProvider.class);
        this.provider = provider;
        this.action = new BitwardenCredentialStoreAction(this);
    }

    @Nonnull
    public ItemGroup<?> getContext() {
        return Jenkins.get();
    }

    public boolean hasPermission2(@Nonnull Authentication a, @Nonnull Permission permission) {
        return Jenkins.get().getACL().hasPermission2(a, permission);
    }

    public CredentialsStoreAction getStoreAction() {
        return this.action;
    }

    public String getDisplayName() {
        return Messages.BitwardenCredentialsStore_DisplayName();
    }

    public boolean addCredentials(@Nonnull Domain domain, @Nonnull Credentials credentials) {
        return false;
    }

    public boolean removeCredentials(@Nonnull Domain domain, @Nonnull Credentials credentials) {
        return false;
    }

    public boolean updateCredentials(@Nonnull Domain domain, @Nonnull Credentials current, @Nonnull Credentials replacement) {
        return false;
    }

    @Nonnull
    public List<Credentials> getCredentials(@Nonnull Domain domain) {
        if (!this.hasPermission2(Jenkins.getAuthentication2(), CredentialsProvider.VIEW)) {
            return Collections.emptyList();
        }
        if (!Domain.global().equals((Object)domain)) {
            return Collections.emptyList();
        }
        return this.provider.listCredentials();
    }

    @ExportedBean
    public static class BitwardenCredentialStoreAction
    extends CredentialsStoreAction {
        private final BitwardenCredentialsStore store;

        private BitwardenCredentialStoreAction(BitwardenCredentialsStore store) {
            this.store = store;
        }

        @Nonnull
        public CredentialsStore getStore() {
            return this.store;
        }

        public String getDisplayName() {
            return Messages.BitwardenCredentialsStore_DisplayName();
        }
    }
}

