/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.text.DateFormat;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class JsonParser {
    private static final JsonMapper mapper = JsonParser.createMapper();

    public static <T> T toJava(String data, Class<T> type) throws IOException {
        return (T)mapper.readValue(data, type);
    }

    public static String toString(Object value) throws IOException {
        return mapper.writeValueAsString(value);
    }

    private static JsonMapper createMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().defaultDateFormat((DateFormat)new StdDateFormat())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    }
}

