/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.azurecredentialsk8s;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.microsoft.azure.util.AzureCredentials;
import hudson.Extension;
import hudson.util.Secret;
import io.jenkins.plugins.azurecredentialsk8s.AzureEnvironments;
import io.jenkins.plugins.azurecredentialsk8s.Base64Utils;

@Extension
public class AzureServicePrincipalCredentialsConvertor
extends SecretToCredentialConverter {
    public boolean canConvert(String type) {
        return "azureServicePrincipal".equals(type);
    }

    public AzureCredentials convert(io.fabric8.kubernetes.api.model.Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull((Object)secret.getData(), (String)"azureCredentials kubernetes definition contains no data");
        String credsId = SecretUtils.getCredentialId((io.fabric8.kubernetes.api.model.Secret)secret);
        String description = SecretUtils.getCredentialDescription((io.fabric8.kubernetes.api.model.Secret)secret);
        CredentialsScope scope = SecretUtils.getCredentialScope((io.fabric8.kubernetes.api.model.Secret)secret);
        String subscriptionIdBase64 = SecretUtils.getNonNullSecretData((io.fabric8.kubernetes.api.model.Secret)secret, (String)"subscriptionId", (String)"azureCredentials service principal credential is missing the subscriptionId");
        String subscriptionId = Base64Utils.base64DecodeToString(subscriptionIdBase64);
        if (subscriptionId == null || subscriptionId.length() <= 0) {
            throw new CredentialsConvertionException("Can't continue as subscriptionId is empty");
        }
        subscriptionId = subscriptionId.trim();
        String clientIdBse64 = SecretUtils.getNonNullSecretData((io.fabric8.kubernetes.api.model.Secret)secret, (String)"clientId", (String)"azureCredentials service principal credential is missing the clientId");
        String clientId = Base64Utils.base64DecodeToString(clientIdBse64);
        if (clientId == null || clientId.length() <= 0) {
            throw new CredentialsConvertionException("Can't continue as clientId is empty");
        }
        clientId = clientId.trim();
        String clientSecretBase64 = SecretUtils.getNonNullSecretData((io.fabric8.kubernetes.api.model.Secret)secret, (String)"clientSecret", (String)"azureCredentials service principal credential is missing the clientSecret");
        String clientSecret = Base64Utils.base64DecodeToString(clientSecretBase64);
        if (clientSecret == null || clientSecret.length() <= 0) {
            throw new CredentialsConvertionException("Can't continue as clientSecret is empty");
        }
        clientSecret = clientSecret.trim();
        String tenantIdBase64 = SecretUtils.getNonNullSecretData((io.fabric8.kubernetes.api.model.Secret)secret, (String)"tenantId", (String)"azureCredentials service principal credential is missing the tenantId");
        String tenantId = Base64Utils.base64DecodeToString(tenantIdBase64);
        if (tenantId == null || tenantId.length() <= 0) {
            throw new CredentialsConvertionException("Can't continue as tenantId is empty");
        }
        tenantId = tenantId.trim();
        AzureCredentials azureCredentials = new AzureCredentials(scope, credsId, description, subscriptionId, clientId, Secret.fromString((String)clientSecret));
        azureCredentials.setTenant(tenantId);
        try {
            String azureEnvironment = Base64Utils.base64DecodeToString(SecretUtils.getNonNullSecretData((io.fabric8.kubernetes.api.model.Secret)secret, (String)"azureEnvironment", (String)"azureCredentials service principal credential is missing the azureEnvironment. Defaults to \"Azure\""));
            azureEnvironment = azureEnvironment != null ? azureEnvironment.trim() : "";
            azureCredentials.setAzureEnvironmentName(AzureEnvironments.valueOfLabel((String)azureEnvironment).label);
        }
        catch (CredentialsConvertionException convertionException) {
            azureCredentials.setAzureEnvironmentName(AzureEnvironments.AZURE.label);
        }
        return azureCredentials;
    }
}

