/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.azurecredentialsk8s;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.microsoft.azure.util.AzureImdsCredentials;
import hudson.Extension;
import io.fabric8.kubernetes.api.model.Secret;
import io.jenkins.plugins.azurecredentialsk8s.AzureEnvironments;
import io.jenkins.plugins.azurecredentialsk8s.Base64Utils;

@Extension
public class AzureManagedIdentityCredentialsConvertor
extends SecretToCredentialConverter {
    public boolean canConvert(String type) {
        return "azureManagedIdentity".equals(type);
    }

    public AzureImdsCredentials convert(Secret secret) throws CredentialsConvertionException {
        String clientId;
        String subscriptionId;
        SecretUtils.requireNonNull((Object)secret.getData(), (String)"azureManagedIdentity kubernetes definition contains no data");
        String credsId = SecretUtils.getCredentialId((Secret)secret);
        String description = SecretUtils.getCredentialDescription((Secret)secret);
        CredentialsScope scope = SecretUtils.getCredentialScope((Secret)secret);
        String subscriptionIdBase64 = SecretUtils.getNonNullSecretData((Secret)secret, (String)"subscriptionId", (String)"azureManagedIdentity service principal credential is missing the subscriptionId");
        String string = subscriptionId = subscriptionIdBase64 != null && subscriptionIdBase64.length() > 0 ? Base64Utils.base64DecodeToString(subscriptionIdBase64) : "";
        if (subscriptionId == null || subscriptionId.length() <= 0) {
            throw new CredentialsConvertionException("Can't continue as subscriptionId is empty");
        }
        subscriptionId = subscriptionId.trim();
        String clientIdBase64 = SecretUtils.getNonNullSecretData((Secret)secret, (String)"clientId", (String)"azureManagedIdentity service principal credential is missing the clientId");
        String string2 = clientId = clientIdBase64 != null && clientIdBase64.length() > 0 ? Base64Utils.base64DecodeToString(clientIdBase64) : "";
        if (clientId == null || clientId.length() <= 0) {
            throw new CredentialsConvertionException("Can't continue as clientId is empty");
        }
        clientId = clientId.trim();
        String azureEnvironment = "";
        try {
            azureEnvironment = Base64Utils.base64DecodeToString(SecretUtils.getNonNullSecretData((Secret)secret, (String)"azureEnvironment", (String)"azureManagedIdentity service principal credential is missing the azureEnvironment. Defaults to \"Azure\""));
            azureEnvironment = azureEnvironment != null ? azureEnvironment : "";
        }
        catch (CredentialsConvertionException convertionException) {
            azureEnvironment = AzureEnvironments.AZURE.label;
        }
        AzureImdsCredentials azureImdsCredentials = new AzureImdsCredentials(scope, credsId, description, azureEnvironment.trim());
        azureImdsCredentials.setClientId(clientId.trim());
        azureImdsCredentials.setSubscriptionId(subscriptionId.trim());
        return azureImdsCredentials;
    }
}

