/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.factory.file;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.SecretBytes;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import io.jenkins.plugins.credentials.secretsmanager.AwsCredentialsProvider;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;

public class AwsFileCredentials
extends BaseStandardCredentials
implements FileCredentials {
    @Nonnull
    private final String fileName;
    @Nonnull
    private final Supplier<SecretBytes> content;

    public AwsFileCredentials(String id, String description, String fileName, Supplier<SecretBytes> content) {
        super(id, description);
        this.fileName = fileName;
        this.content = content;
    }

    @Nonnull
    public String getFileName() {
        return this.fileName;
    }

    @Nonnull
    public InputStream getContent() {
        SecretBytes sb = this.content.get();
        return new ByteArrayInputStream(sb.getPlainData());
    }

    @Nonnull
    SecretBytes getContentBytes() {
        return this.content.get();
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.file();
        }

        public boolean isApplicable(CredentialsProvider provider) {
            return provider instanceof AwsCredentialsProvider;
        }
    }
}

