/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.factory;

import com.cloudbees.plugins.credentials.CredentialsUnavailableException;
import com.cloudbees.plugins.credentials.SecretBytes;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.Secret;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import io.jenkins.plugins.credentials.secretsmanager.factory.SecretValue;
import io.jenkins.plugins.credentials.secretsmanager.factory.certificate.AwsCertificateCredentials;
import io.jenkins.plugins.credentials.secretsmanager.factory.file.AwsFileCredentials;
import io.jenkins.plugins.credentials.secretsmanager.factory.ssh_user_private_key.AwsSshUserPrivateKey;
import io.jenkins.plugins.credentials.secretsmanager.factory.string.AwsStringCredentials;
import io.jenkins.plugins.credentials.secretsmanager.factory.username_password.AwsUsernamePasswordCredentials;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

public abstract class CredentialsFactory {
    private CredentialsFactory() {
    }

    public static Optional<StandardCredentials> create(String arn, String name, String description, Map<String, String> tags, SecretsManagerClient client) {
        String type = tags.getOrDefault("jenkins:credentials:type", "");
        String username = tags.getOrDefault("jenkins:credentials:username", "");
        String filename = tags.getOrDefault("jenkins:credentials:filename", name);
        switch (type) {
            case "string": {
                return Optional.of(new AwsStringCredentials(name, description, new SecretSupplier(client, arn)));
            }
            case "usernamePassword": {
                return Optional.of(new AwsUsernamePasswordCredentials(name, description, new SecretSupplier(client, arn), username));
            }
            case "sshUserPrivateKey": {
                return Optional.of(new AwsSshUserPrivateKey(name, description, new StringSupplier(client, arn), username));
            }
            case "certificate": {
                return Optional.of(new AwsCertificateCredentials(name, description, new SecretBytesSupplier(client, arn)));
            }
            case "file": {
                return Optional.of(new AwsFileCredentials(name, description, filename, new SecretBytesSupplier(client, arn)));
            }
        }
        return Optional.empty();
    }

    private static class SecretSupplier
    extends RealSecretsManager
    implements Supplier<Secret> {
        private SecretSupplier(SecretsManagerClient client, String name) {
            super(client, name);
        }

        @Override
        public Secret get() {
            return this.getSecretValue().match(new SecretValue.Matcher<Secret>(){

                @Override
                public Secret string(String str) {
                    return Secret.fromString((String)str);
                }

                @Override
                public Secret binary(byte[] bytes) {
                    return null;
                }
            });
        }
    }

    private static class StringSupplier
    extends RealSecretsManager
    implements Supplier<String> {
        private StringSupplier(SecretsManagerClient client, String name) {
            super(client, name);
        }

        @Override
        public String get() {
            return this.getSecretValue().match(new SecretValue.Matcher<String>(){

                @Override
                public String string(String str) {
                    return str;
                }

                @Override
                public String binary(byte[] bytes) {
                    return null;
                }
            });
        }
    }

    private static class SecretBytesSupplier
    extends RealSecretsManager
    implements Supplier<SecretBytes> {
        private SecretBytesSupplier(SecretsManagerClient client, String name) {
            super(client, name);
        }

        @Override
        public SecretBytes get() {
            return this.getSecretValue().match(new SecretValue.Matcher<SecretBytes>(){

                @Override
                public SecretBytes string(String str) {
                    return null;
                }

                @Override
                public SecretBytes binary(byte[] bytes) {
                    return SecretBytes.fromBytes((byte[])bytes);
                }
            });
        }
    }

    private static class RealSecretsManager {
        private static final Logger LOG = Logger.getLogger(RealSecretsManager.class.getName());
        private final String id;
        private final transient SecretsManagerClient client;

        RealSecretsManager(SecretsManagerClient client, String id) {
            this.client = client;
            this.id = id;
        }

        @NonNull
        SecretValue getSecretValue() {
            GetSecretValueRequest request = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(this.id).build();
            try {
                GetSecretValueResponse result = this.client.getSecretValue(request);
                if (result.secretBinary() != null) {
                    return SecretValue.binary(result.secretBinary().asByteArray());
                }
                if (result.secretString() != null) {
                    return SecretValue.string(result.secretString());
                }
                throw new IllegalStateException(Messages.emptySecretError(this.id));
            }
            catch (SecretsManagerException ex) {
                LOG.warning("AWS Secrets Manager retrieval error");
                LOG.warning(ex.getMessage());
                throw new CredentialsUnavailableException("secret", Messages.couldNotRetrieveCredentialError(this.id));
            }
        }
    }
}

